import sys
import os

from pathlib import Path
import pandas as pd

# Wiersz niezbędny, aby platforma pytest poprawnie zaimportowała moduły.
myPath = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, myPath + "/../")

from ml_editor.data_ingestion import parse_xml_to_csv

TEXT_LENGTH_FIELD = "text_len"

# Niezbędne cechy są zdefiniowane na najwyższym poziomie testu.
REQUIRED_COLUMNS = [
    "Id",
    "AnswerCount",
    "PostTypeId",
    "AcceptedAnswerId",
    "Body",
    "body_text",
    "Title",
    "Score",
]

# Dopuszczalny interwał oparty na ekstrapolacji danych.
ACCEPTABLE_TEXT_LENGTH_MEANS = pd.Interval(left=20, right=2000)


def get_fixture_df():
    """
    Utworzenie obiektu DataFrame za pomocą parsera.
    :return:
    """
    curr_path = Path(os.path.dirname(__file__))
    return parse_xml_to_csv(curr_path / Path("fixtures/MiniPosts.xml"))


def test_parser_returns_dataframe():
    """
    Sprawdzenie, czy kod analizujący składnię danych zwraca obiekt DataFrame.
    """
    df = get_fixture_df()
    assert isinstance(df, pd.DataFrame)


def test_feature_columns_exist():
    """
    Sprawdzenie, czy dostępne są wszystkie ważne kolumny.
    """
    df = get_fixture_df()
    for col in REQUIRED_COLUMNS:
        assert col in df.columns


def test_features_not_all_null():
    """
    Sprawdzenie, czy wszystkie cechy zawierają wartości.
    """
    df = get_fixture_df()
    for col in REQUIRED_COLUMNS:
        assert not df[col].isnull().all()


def test_text_mean():
    """
    Sprawdzenie, czy wartość średnia jest zgodna z oczekiwaniami.
    """
    df = get_fixture_df()
    df["text_len"] = df["body_text"].str.len()
    text_col_mean = df["text_len"].mean()
    assert text_col_mean in ACCEPTABLE_TEXT_LENGTH_MEANS
