from sklearn.ensemble import RandomForestClassifier


def get_filtering_model(classifier, features, labels):
    """
    Wyliczenie błędu prognozy dla zbioru danych klasyfikatora binarnego.
    :param classifier: przetrenowany klasyfikator
    :param features: cechy wejściowe
    :param labels: rzeczywiste etykiety
    """
    predictions = classifier.predict(features)
    # Utworzenie etykiet, gdzie 1 oznacza błąd, a 0 poprawną prognozę.
    is_error = [pred != truth for pred, truth in zip(predictions, labels)]

    filtering_model = RandomForestClassifier()
    filtering_model.fit(features, is_error)
    return filtering_model
