# File-Name:       package_installer.R           
# Date:            2012-02-10                         
# Author:          Drew Conway (drew.conway@nyu.edu)
# Purpose:         Instaluje wszystkie pakiety potrzebne do przypadków testowych Uczenie maszynowe dla programistów
# Data Used:       n.d.
# Packages Used:   n.d.

# All source code is copyright (c) 2012, under the Simplified BSD License.  
# For more information on FreeBSD see: http://www.opensource.org/licenses/bsd-license.php

# All images and materials produced by this code are licensed under the Creative Commons 
# Attribution-Share Alike 3.0 United States License: http://creativecommons.org/licenses/by-sa/3.0/us/

# All rights reserved.

# Tworzy wektor zawierający nazwy wszystkich pakietów wykorzystywanych w przypadkach testowych (kolejność bez znaczenia)

options(repos=structure(c(CRAN="http://cran.stat.auckland.ac.nz/")))

cran.packages <- c("e1071",
                   "ggplot2",
                   "glmnet",
                   "Hmisc",
                   "igraph",
                   "lme4",
                   "lubridate",
                   "plyr",
                   "RCurl",
                   "reshape",
                   "RJSONIO",
                   "scales",
                   "tm",
                   "XML")

cat("Skrypt przystąpi do instalacji wszystkich pakietów R wykorzystywanych w 'Uczenie maszynowe dla programistów'")

for(p in cran.packages) {
    if(!suppressWarnings(require(p, character.only = TRUE, quietly = TRUE))) {
        cat(paste(p, "brak pakietu, instalowanie\n"))
        install.packages(p, dependencies = TRUE, type = "source")
    }
    else {
        cat(paste(p, "zainstalowany\n"))
    }
}

print("### Wszystkie niezbędne pakiety zainstalowane ###")

