---
name: Bug report
about: Create a report to help us improve
title: "[BUG]"
labels: ''
assignees: ''

---

Thanks for helping us improve this project!

**Before you create this issue**
Please make sure you are using the latest updated code and libraries: see https://github.com/ageron/handson-ml3/blob/main/INSTALL.md#update-this-project-and-its-libraries

Also please make sure to read the FAQ (https://github.com/ageron/handson-ml3#faq) and search for existing issues (both open and closed), as your question may already have been answered: https://github.com/ageron/handson-ml3/issues

**Describe the bug**
Please provide a clear and concise description of what the bug is, and specify the notebook name and the cell number at which the problem occurs (or the chapter and page in the book).

**To Reproduce**
Please copy the code that fails here, using code blocks like this:

```python
def inverse(x):
    return 1 / x

result = inverse(0)
```

And if you got an exception, please copy the full stacktrace here:

```stacktrace
Traceback (most recent call last):
  File "<stdin>", line 1, in <module>
  File "<stdin>", line 2, in inverse
ZeroDivisionError: division by zero
```

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Versions (please complete the following information):**
 - OS: [e.g. MacOSX 10.15.7]
 - Python: [e.g. 3.7]
 - TensorFlow: [e.g., 2.4.1]
 - Scikit-Learn: [e.g., 0.24.1]
- Other libraries that may be connected with the issue: [e.g., gym 0.18.0]

**Additional context**
Add any other context about the problem here.
