import {
  checkAvailability,
  getDestinations,
  holdSeats,
  reserveSeats,
} from './flights';

describe('testy lotów', () => {
  const destinations = getDestinations();
  let flight = destinations[0];
  test('pobieranie destynacji', () => {
    expect(destinations).toHaveLength(7);
  });
  test('sprawdzanie dostępności', () => {
    const destinations = getDestinations();
    expect(checkAvailability(destinations[0], 3)).toBeTruthy();
    expect(checkAvailability(destinations[1], 5)).toBeFalsy();
    expect(checkAvailability(destinations[2], 300)).toBeFalsy();
    expect(checkAvailability(destinations[3], 3)).toBeTruthy();
  });
  test('przytrzymywanie miejsc', () => {
    expect.assertions(3);
    flight = holdSeats(flight, 3);
    expect(flight.seatsHeld).toBe(3);
    flight = holdSeats(flight, 13);
    expect(flight.seatsHeld).toBe(16);
    try {
      holdSeats(flight, 15);
    } catch (e) {
      expect(e.message).toBe('Nie ma wystarczającej liczby miejsc!');
    }
  });
  test('rezerwacja miejsc', () => {
    expect.assertions(3);
    flight = reserveSeats(flight, 3);
    expect(flight.seatsRemaining).toBe(27);
    flight = reserveSeats(flight, 13);
    expect(flight.seatsRemaining).toBe(14);
    try {
      reserveSeats(flight, 1);
    } catch (e) {
      expect(e.message).toBe('Miejsca nie zostały przytrzymane!');
    }
  });
});
