/** ---------- toTitleCase ---------- **/

function toTitleCase (input:string) : string {
    // Dzielimy string na tablicę po każdym wystąpieniu znaku spacji
    const words = input.split(" ");
    const titleWords = [];
    // Wykonujemy pętle przez każde słowo
    for (const word of words) {
        // Przyjmujemy pierwszy znak pzy użyciu `slice` i konwertujemy go na wielką literę
        const initial = word.slice(0, 1).toLocaleUpperCase();
        // Przyjmujemy resztę znaków przy użyciu `slice` i konwertujemy je na małe litery
        const rest = word.slice(1).toLocaleLowerCase();
        // Łączymy initial oraz rest i dodajemy je do wynikowej tablicy
        titleWords.push(`${initial}${rest}`);
    }
    // Łączymy wszystkie przetworzone słowa
    const result = titleWords.join(" ");
    return result;
}


console.log(`toTitleCase("wojna I pokój"):`);
console.log(toTitleCase("wojna I pokój"));
 
console.log(`toTitleCase("Buszujący w Zbożu"):`);
console.log(toTitleCase("Buszujący w Zbożu"));

console.log(`toTitleCase("zABIĆ dROZDA"):`);
console.log(toTitleCase("zABIĆ dROZDA"));

/** ---------- countWords ---------- **/

function countWords (input: string): number {
    // Dzielimy słowa za pomocą wyrażenia regularnego, które będzie dopasowywać każe wystąpienie
    // znaku spacji, podkreślnika lub dywizu
    const words = input.split(/[ _-]/);
    // Zwracamy długość tablicy będącej wynikiem dzielenia
    return words.length;
}

console.log(`countWords("Wojna i Pokój"):`);
console.log(countWords("Wojna i Pokój"));
 
console.log(`countWords("buszujący-w-zbożu"):`);
console.log(countWords("buszujący-w-zbożu"));

console.log(`countWords("komu_bije dzwon"):`);
console.log(countWords("komu_bije dzwon"));

/** ---------- toWords ---------- **/

function toWords (input: string): string[] {
    // Dzielimy słowa za pomocą wyrażenia regularnego, które będzie dopasowywać każe wystąpienie
    // znaku spacji, podkreślnika lub dywizu
    const words = input.split(/[ _-]/);
    return words;
}

console.log(`toWords("Wojna i Pokój"):`);
console.log(toWords("Wojna i Pokój"));
 
console.log(`toWords("buszujący-w-zbożu"):`);
console.log(toWords("buszujący-w-zbożu"));

console.log(`toWords("komu_bije dzwon"):`);
console.log(toWords("komu_bije dzwon"));

/** ---------- repeat ---------- **/

function repeat (input: string, times: number): string {
    // Tworzymy nową tablicę o długości `times`
    // i dla każdego elementu ustawiamy wartość łańcucha znaków `input` 
    const instances = new Array(times).fill(input);
    // Łączymy elementy tablicy
    const result = instances.join("");
    return result;
}

console.log(`repeat("Wojna", 3 ):`);
console.log(repeat("Wojna", 3 ));
 
console.log(`repeat("zbożu", 1):`);
console.log(repeat("zbożu", 1));

console.log(`repeat("dzwon", 0):`);
console.log(repeat("dzwon", 0));

/** ---------- isAlpha ---------- **/

function isAlpha (input: string): boolean {
    // Wyrażenie regularne, które będzie dopasowywać każdy łańcuch znaków, który ma tylko wielkie i małe litery 
    const alphaRegex = /^[a-z]*$/i
    // Testujemy input przy użyciu wyrażenia regularnego
    const result = alphaRegex.test(input);
    return result;
}

console.log(`isAlpha("Wojna i Pokój"):`);
console.log(isAlpha("Wojna i Pokój"));
 
console.log(`isAlpha("Pokuta"):`);
console.log(isAlpha("Pokuta"));

console.log(`isAlpha("1Q84"):`);
console.log(isAlpha("1Q84"));


/** ---------- isBlank ---------- **/

function isBlank (input: string): boolean {
    // Testujemmy, czy pierwszy znak input jest spacją
    while (input[0] === " ") {
        // Sukcesywnie wycinamy pierwszy znak input
        input = input.slice(1);
    }
    // Pętla zatrzyma się na pierwszym znaku, który nie będzie spacją
    // Jeżeli pozostanie nam punsty łańcuch znaków, w input będziemy mieli tylko spacje
    const result = input === "";
    return result;
}

console.log(`isBlank("Wojna i Pokój"):`);
console.log(isBlank("Wojna i Pokój"));
 
console.log(`isBlank("       "):`);
console.log(isBlank("       "));

console.log(`isBlank(""):`);
console.log(isBlank(""));
