<?php
/**
 * Klasa narzędziowa UserUtil
 *
 * Autor: Mario Andres Pagella (andres.pagella@gmail.com) 
 *
 * Ten kod pochodzi z książki "Tworzenie izometrycznych, społecznościowych
 * gier strategicznych w języku JavaScript".
 * 
 * Zamieszczonego tu kodu nie należy traktować jak produkcyjnego, ponieważ nie
 * został gruntownie przetestowany. Jest dostarczany w takiej formie bez żadnej gwarancji.
 */ 


if (!class_exists('User')) {
	require_once ('class.user.php');
}

define('DEBUG_MODE', true); // Ustaw na false, aby ukryć komunikaty o błędach MySQL

class UserUtil
{
	private $DBRef;
		
	final public function __construct($DBObj)
	{						
		if (!isset($DBObj)) {
			if (DEBUG_MODE) {
				die("The DB Object is invalid");
			}
			return false;
		} else {
			$this->DBRef = $DBObj;
			return true;
		}
	}

	final public function getBalanceByUserId($userId)
	{
		$userId = (int)$userId;
	
		$query = "SELECT BALANCE FROM users WHERE ID = $userId ";
		
		$res = $this->DBRef->GetSingleResult($query);

		return $res['BALANCE'];
	}

	final public function create($user)
	{
		if (!($user instanceof User)) {
			throw new Exception('Invalid user object');
		}

		$username = $this->DBRef->filterString($user->getName());
		$username = $this->DBRef->sanitizeString($username);

		$password = $this->DBRef->filterString($user->getPassword());
		$email = $this->DBRef->filterString($user->getEmail());

		$t = time();
		$user->setCreationTime($t);
		$user->setLastUpdate($t);

		$query = "INSERT INTO users (NAME, PASSWORD, EMAIL, BALANCE, CONFIG, CREATIONTIME, LASTUPDATE) ";
		$query .= "VALUES (";
		$query .= "'" . $username . "', ";
		$query .= "'" . $password . "', ";
		$query .= "'" . $email . "', ";
		$query .= $user->getBalance() . ", ";
		$query .= "'" . $user->getConfig() . "', ";
		$query .= $user->getCreationTime() . ", ";
		$query .= $user->getLastUpdate();
		$query .= ")";
		
		if ($this->DBRef->ExecQuery($query)) {
			$user->setId ($this->DBRef->getInsertedId());
		}

		return $user;
	}

	final public function update($user)
	{
		if (!($user instanceof User)) {
			throw new Exception('Invalid user object');
		}

		$username = $this->DBRef->filterString($user->getName());
		$username = $this->DBRef->sanitizeString($username);

		$password = $this->DBRef->filterString($user->getPassword());
		$email = $this->DBRef->filterString($user->getEmail());

		$t = time();
		$user->setLastUpdate($t);

		$query = "UPDATE users SET ";
		$query .= "NAME = '" . $username . "', ";
		$query .= "EMAIL = '" . $email . "', ";
		$query .= "BALANCE = " . $user->getBalance() . ", ";
		$query .= "CONFIG = '" . $user->getConfig() . "', ";
		$query .= "LASTUPDATE = " . $user->getLastUpdate() ." ";
		$query .= "WHERE ID = " . $user->getId();
		
		$this->DBRef->ExecQuery($query);
	}

	final public function getUserById($userId)
	{
		$userId = (int)$userId;

		$query = "SELECT * FROM users WHERE ID = $userId ";

		$res = $this->DBRef->GetSingleResult($query);

		if (!$res || count($res) == 0) {
			return null;
		} else {
			$user = new User($res['ID'], $res['NAME'], $res['EMAIL']);
			$user->setPassword($res['PASSWORD']);
			$user->setBalance($res['BALANCE']);
			$user->setConfig($res['CONFIG']);
			$user->setCreationTime($res['CREATIONTIME']);
			$user->setLastUpdate($res['LASTUPDATE']);

			return $user;
		}
	}

	final public function listUsers($start = null, $limit = null)
	{
		$query = "SELECT * FROM users ";

		if ($start != null && $limit != null) {
			$start = (int)$start;
			$limit = (int)$limit;

			$query .= "LIMIT $start, $limit ";
		}

		$res = $this->DBRef->GetAllResults($query);

		if (count($res) == 0) {
			return null;
		} else {
			$arr = array();
			for ($i = 0, $x = count($res); $i < $x; $i++) {
				
				$user = new User($res[$i]['ID'], $res[$i]['NAME'], $res[$i]['EMAIL']);
				$user->setPassword($res[$i]['PASSWORD']);
				$user->setBalance($res[$i]['BALANCE']);
				$user->setConfig($res[$i]['CONFIG']);
				$user->setCreationTime($res[$i]['CREATIONTIME']);
				$user->setLastUpdate($res[$i]['LASTUPDATE']);

				array_push($arr, $user);
			}

			return $arr;
		}
	}

	final public function removeUser($user)
	{
		$id = $user->getId();

		$query = "DELETE FROM users WHERE ID = $id ";

		return $this->DBRef->ExecQuery($query);
	}

	final public function authenticate($email, $password) {
		$email = (isset($email)) ? $email : "";
		$password = (isset($password)) ? $password : "";

		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			return null;
		}

		if (strlen($password) == 0) {
			return null;
		}

		$email = $this->DBRef->filterString($email);
		$password = sha1($password);

		$query = "SELECT * FROM users WHERE ";
		$query .= "EMAIL = '$email' AND ";
		$query .= "PASSWORD = '$password' ";

		$res = $this->DBRef->GetSingleResult($query);

		if (count($res) == 0 || $res == 0) {
			return null;
		} else {
			$user = new User((int)$res['ID'], $res['NAME'], $res['EMAIL']);
			$user->setPassword($res['PASSWORD']);
			$user->setBalance($res['BALANCE']);
			$user->setConfig($res['CONFIG']);
			$user->setCreationTime($res['CREATIONTIME']);
			$user->setLastUpdate($res['LASTUPDATE']);

			return $user;
		}
	}
}
?>
