<?php
/**
 * Klasa User
 *
 * Autor: Mario Andres Pagella (andres.pagella@gmail.com) 
 *
 * Ten kod pochodzi z książki "Tworzenie izometrycznych, społecznościowych
 * gier strategicznych w języku JavaScript".
 * 
 * Zamieszczonego tu kodu nie należy traktować jak produkcyjnego, ponieważ nie
 * został gruntownie przetestowany. Jest dostarczany w takiej formie bez żadnej gwarancji.
 */ 

class User
{
	private $id, $name, $email, $password = "", $balance = 20000, $config = "", $creationTime = 0, $lastUpdate = 0;

	final public function __construct($id, $name, $email)
	{						
		if ($id != null) {
			$this->setId($id);
		}
		
		$this->setName($name);
		$this->setEmail($email);
	}

	final public function getId() { return (int)$this->id; }
	final public function setId($id) { $this->id = (int)$id; }

	final public function getName() { return $this->name; }
	final public function setName($name) { $this->name = $name; }

	final public function getEmail() { return $this->email; }
	final public function setEmail($email) { 
		if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			throw new Exception('Invalid email address');
		} else {
			$this->email = $email;
		}
	}

	final public function getPassword() { return $this->password; }
	final public function setPassword($password) { $this->password = sha1($password); }

	final public function getBalance() { return (int)$this->balance; }
	final public function setBalance($balance) { $this->balance = (int)$balance; }

	final public function getConfig() { return $this->config; }
	final public function setConfig($config) { $this->config = $config; }

	final public function getCreationTime() { return (int)$this->creationTime; }
	final public function setCreationTime($time) { $this->creationTime = (int)$time; }

	final public function getLastUpdate() { return (int)$this->lastUpdate; }
	final public function setLastUpdate($time) { $this->lastUpdate = (int)$time; }
}
?>
