<?php

	// Przed wywołaniem session_start() dołącza definicje klas
	require_once ('classes/class.dbutil.php');
	require_once ('classes/class.users.php');
	require_once ('classes/class.user.php');
	require_once ('config.php');

	session_start();

	$error = false;

	if (count($_POST) != 0 && !isset($_SESSION['userSession'])) {
	  $DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				   	 DB_USER,		// Użytkownik bazy danych
				   	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				   	 DB_NAME);		// Nazwa bazy danych

		if ($DB) {
			$UserUtil = new UserUtil($DB);

			$user = $UserUtil->authenticate($_POST['email'], $_POST['password']);

			if ($user) {
				$_SESSION['userSession'] = $user;
			} else {
				$error = true;
			}
		}
	}

?>
<!DOCTYPE html>
<html lang="pl">
	<head>
		<meta charset="UTF-8" />
		<title>Przykład uwierzytelniania</title>
	</head>
	<body>
		<?php if (!isset($_SESSION['userSession'])) { ?>

			<?php if ($error) { ?>
				<strong>Podczas uwierzytelniania użytkownika doszło do błędu. Sprawdź adres e-mail i hasło, a następnie spróbuj ponownie.</strong>
				<br />
			<?php } ?>
		
			<form action="<?php $_SERVER['PHP_SELF']?>" method="post">
				
				E-mail: <input type="email" name="email" /><br />

				Hasło: <input type="password" name="password" /><br />

				<input type="submit" value="Zaloguj" />

			</form>

		<?php } else { ?>
			
			Witaj, <strong><?=$_SESSION['userSession']->getName()?></strong>. Stan Twojego konta wynosi <?=$_SESSION['userSession']->getBalance()?>.

		<?php } ?>
	</body>
</html>
