<?php

	// Dołącza definicje klas przed wywołaniem session_start()
	require_once ('../server/classes/class.dbutil.php');
	require_once ('../server/classes/class.users.php');
	require_once ('../server/classes/class.operations.php');
	require_once ('../server/classes/class.buildingInstance.php');
	require_once ('../server/classes/class.user.php');
	require_once ('../server/config.php');

	session_start();

	if (isset($_SESSION['userSession'])) {
		// Jeśli użytkownik jest już zalogowany, przekieruj go do gry.
		header("location: game.php");
	}

	$loginError = false;
	$registerError = false;

	if (count($_POST) != 0 && isset($_POST['type'])) {

	  $DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				   	 DB_USER,		// Użytkownik bazy danych
				   	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				   	 DB_NAME);		// Nazwa bazy danych

		if ($DB) {
			
			$UserUtil = new UserUtil($DB);
			$OperUtil = new OperationsUtil($DB);

			if ($_POST['type'] == 'login') {
				$user = $UserUtil->authenticate($_POST['email'], $_POST['password']);

				if ($user) {
					$_SESSION['userSession'] = $user;
					header("location: game.php");
				} else {
					$loginError = true;
				}
			} else {
				if (strlen($_POST['name']) == 0 || strlen($_POST['password']) == 0) {
					$registerError = true;
				} else {
					$user = new User(null, $_POST['name'], $_POST['email']);
					$user->setPassword($_POST['password']);

					$user = $UserUtil->create($user);

					if ($user) {

						// Wypełnia 10% siatki (jej rozmiar jest zdefiniowany w pliku config.php) drzewami.
						// Dla ułatwienia tutaj został na stałe wpisany identyfikator 4.

						$amtX = round(10 * GRID_X) / 100;
						$amtY = round(10 * GRID_Y) / 100;

						for ($i = 0; $i < $amtX; $i++) {
							for ($j = 0; $j < $amtY; $j++) {
								$bi = new BuildingInstance(null, $user->getId(), 4, mt_rand(0, GRID_X), mt_rand(0, GRID_Y));
								$OperUtil->create($bi);		
							}
						}

						$_SESSION['userSession'] = $user;
						header("location: game.php");
					} else {
						$registerError = true;
					}
				}
			}

		}
	}

?>
<!DOCTYPE html>
<html lang="pl">
	<head>
		<meta charset="UTF-8" />
		<title>Tourist Resort</title>
		<link rel="stylesheet" href="css/site.css" />
		<script src="../utils/modernizr-1.7.min.js" charset="utf-8"></script>

		<script>
			window.onload = function () {
				var pointer = {
					UP: 'mouseup'
				};

				if (Modernizr.touch){
					pointer.UP = 'touchend';
				}

				document.body.addEventListener(pointer.UP, handleClick, false);
			}

			function handleClick(e) {
				// Upewnij się, że kliknięty został przycisk
				if (e.target.tagName == 'INPUT') {
					switch(e.target.getAttribute("id")) {
						case "btnSignIn":
							e.target.parentNode.setAttribute("class", "hidden");
							document.getElementById('signInArea').setAttribute("class", "");
							break;
						case "btnRegister":
							e.target.parentNode.setAttribute("class", "hidden");
							document.getElementById('registerArea').setAttribute("class", "");
							break;
						default:
							var o = e.target;

							if (o.getAttribute("class")) {
								var classes = o.getAttribute("class").split(" ");

								for (var i = 0; i < classes.length; i++) {
									if (classes[i] == 'cancel') {
										e.target.parentNode.parentNode.setAttribute("class", "hidden");
										document.getElementById('controls').setAttribute("class", "");
									}
								}
							}
							break;
					}
				}
			}
		</script>
	</head>
	<body>
		
			<img src="../img/logo-small.png" alt="Tourist Resort" />

			<div id="controls">
				<input type="button" id="btnSignIn" class="button" value="Sign In" />
				<input type="button" id="btnRegister" class="button" value="Register new user" />
			</div>

			<?php if ($loginError) { ?>
				<p>
					<strong>Podczas logowania wystąpił błąd. Sprawdź wpisany adres e-mail i hasłoCheck, a następnie spróbuj ponownie.</strong>
				</p>
			<?php } else if ($registerError) { ?>
				<p>
					<strong>Podczas rejestrowania wystąpił błąd. Sprawdź wpisany adres e-mail i hasłoCheck, a następnie spróbuj ponownie.</strong>
				</p>
			<?php } ?>

			<div id="signInArea" class="hidden">
				<form action="<?php $_SERVER['PHP_SELF']?>" method="post">
					<input type="hidden" name="type" value="login" />

					E-mail: <input type="email" name="email" /><br />

					Hasło: <input type="password" name="password" /><br />

					<input type="submit" class="button" value="Zaloguj" />
					<input type="button" class="button cancel" value="Anuluj" />

				</form>
			</div>

			<div id="registerArea" class="hidden">
				<form action="<?php $_SERVER['PHP_SELF']?>" method="post">
					<input type="hidden" name="type" value="register" />

					Nazwa użytkownika: <input type="text" name="name" /><br />

					E-mail: <input type="email" name="email" /><br />

					Hasło: <input type="password" name="password" /><br />

					<input type="submit" class="button" value="Zarejestruj" />
					<input type="button" class="button cancel" value="Anuluj" />

				</form>
			</div>

	</body>
</html>
