<?php

	// Przed wywołaniem session_start() dołącza definicje klas
	require_once ('classes/class.dbutil.php');
	require_once ('classes/class.users.php');
	require_once ('classes/class.user.php');
	require_once ('config.php');

	session_start();

	$error = false;

	if (count($_POST) != 0 && !isset($_SESSION['userSession'])) {
	  $DB = new DBUtil(DB_HOST,		// Nazwa hosta serwera bazy danych
				   	 DB_USER,		// Użytkownik bazy danych
				   	 DB_PASSWORD,	// Hasło użytkownika bazy danych
				   	 DB_NAME);		// Nazwa bazy danych

		if ($DB) {
			$UserUtil = new UserUtil($DB);

			if (strlen($_POST['name']) == 0 || strlen($_POST['password']) == 0) {
				$error = true;
			} else {
				$user = new User(null, $_POST['name'], $_POST['email']);
				$user->setPassword($_POST['password']);

				$user = $UserUtil->create($user);

				if ($user) {
					$_SESSION['userSession'] = $user;
				} else {
					$error = true;
				}
			}
		}
	}

?>
<!DOCTYPE html>
<html lang="pl">
	<head>
		<meta charset="UTF-8" />
		<title>Przykład rejestrowania</title>
	</head>
	<body>
		<?php if (!isset($_SESSION['userSession'])) { ?>

			<?php if ($error) { ?>
				<strong>Podczas rejestrowania nowego użytkownika doszło do błędu.</strong>
				<br />
			<?php } ?>
		
			<form action="<?php $_SERVER['PHP_SELF']?>" method="post">
				
				Nazwa użytkownika: <input type="text" name="name" /><br />

				E-mail: <input type="email" name="email" /><br />

				Hasło: <input type="password" name="password" /><br />

				<input type="submit" value="Zarejestruj" />

			</form>

		<?php } else { ?>
			
			Witaj, <strong><?=$_SESSION['userSession']->getName()?></strong>. Stan Twojego konta wynosi <?=$_SESSION['userSession']->getBalance()?>.

		<?php } ?>
	</body>
</html>
