// Maksymalna liczba obiektów dźwiękowych w puli
var MAX_PLAYBACKS = 3;
var globalVolume = 0.3;

function SoundUtil() {
	this.maxPlaybacks = MAX_PLAYBACKS;
	this.audioObjects = []; // Pula obiektów dźwiękowych dostępna do wielokrotnego wykorzystania
}

SoundUtil.prototype.play = function(file, startTime, duration, volume, loop) {

	// Pobiera obiekt dźwiękowy z puli
	var audioObject = this.getAudioObject();
	var suObj = this;

	/** 
	 * W puli nie są dostępne żadne obiekty dźwiękowe. Nic nie odtwarza.
	 * UWAGA: Zastosowano tu rozwiązanie przypominające stosowane w zabawkowych organach.
	 * Innym rozwiązaniem jest dodawanie obiektów do kolejki odtwarzania.
	 */
	if (audioObject !== null) {
		audioObject.obj.loop = loop;
		audioObject.obj.volume = volume;

		for (var i = 0; i < file.length; i++) {
			if (audioObject.obj.canPlayType(file[i][1]) === "probably" ||
				audioObject.obj.canPlayType(file[i][1]) === "maybe") {
				audioObject.obj.src = file[i][0];
				audioObject.obj.type = file[i][1];
				break;
			}
		}

		var playBack = function() {
			// Usuwa obiekt nasłuchujący. Jest to konieczne, by funkcja nie była bez końca wywoływana.
			audioObject.obj.removeEventListener('canplaythrough', playBack, false);
			audioObject.obj.currentTime = startTime;
			audioObject.obj.play();

			// Nie ma potrzeby nasłuchiwać, jeśli obiekt zakończył odtwarzanie w trybie zapętlenia
			if (!loop) {
				setTimeout(function() {
					audioObject.obj.pause();
					suObj.freeAudioObject(audioObject);
				}, duration);
			}
		}

		audioObject.obj.addEventListener('canplaythrough', playBack, false);
	}
}

SoundUtil.prototype.getAudioObject = function() {
	if (this.audioObjects.length === 0) {
		var a = new Audio();
		var audioObject = {
			id: 0,
			obj: a,
			busy: true
		}

		this.audioObjects.push (audioObject);

		return audioObject;
	} else {
		for (var i = 0; i < this.audioObjects.length; i++) {
			if (!this.audioObjects[i].busy) {
				this.audioObjects[i].busy = true;
				return this.audioObjects[i];
			}
		}

		// Żaden obiekt dźwiękowy nie jest wolny. Utworzyć nowy?
		if (this.audioObjects.length <= this.maxPlaybacks) {
			var a = new Audio();
			var audioObject = {
				id: this.audioObjects.length,
				obj: a,
				busy: true
			}

			this.audioObjects.push (audioObject);

			return audioObject;
		} else {
			return null;
		}
	}
}

SoundUtil.prototype.freeAudioObject = function(audioObject) {
	for (var i = 0; i < this.audioObjects.length; i++) {
		if (this.audioObjects[i].id === audioObject.id) {
			this.audioObjects[i].currentTime = 0;
			this.audioObjects[i].busy = false;
		}
	}
}