var buildings = {
    list: {
        "base": {
            name: "base",
            // Właściwości niezbędne podczas rysowania obiektu 

            // Wymiary poszczególnych sprite’ów
            pixelWidth: 60,
            pixelHeight: 60,

            // Wymiary powierzchni bazy 
            baseWidth: 40,
            baseHeight: 40,

            // Przesunięcie obszaru bazy względem górnego lewego rogu sprite’a 
            pixelOffsetX: 0,
            pixelOffsetY: 20,

            // Kwadraty siatki potrzebne podczas konstrukcji budynku
            buildableGrid: [
                [1, 1],
                [1, 1]
            ],

            // Kwadraty siatki, które można przejść lub które są zablokowane
            passableGrid: [
                [1, 1],
                [1, 1]
            ],

            // Jak daleko budynek może "widzieć" poprzez mgłę wojenną
            sight: 3,

            // Maksymalne wartości wyznaczające żywotność 
            hitPoints: 500,

            cost: 5000,

            spriteImages: [
                { name: "healthy", count: 4 },
                { name: "damaged", count: 1 },
                { name: "constructing", count: 3 }
            ],
        },

        "starport": {
            name: "starport",
            pixelWidth: 40,
            pixelHeight: 60,
            baseWidth: 40,
            baseHeight: 55,
            pixelOffsetX: 1,
            pixelOffsetY: 5,
            buildableGrid: [
                [1, 1],
                [1, 1],
                [1, 1]
            ],
            passableGrid: [
                [1, 1],
                [0, 0],
                [0, 0]
            ],
            sight: 3,
            cost: 2000,
            canConstruct: true,
            hitPoints: 300,
            spriteImages: [
                { name: "teleport", count: 9 },
                { name: "closing", count: 18 },
                { name: "healthy", count: 4 },
                { name: "damaged", count: 1 }
            ],
        },

        "harvester": {
            name: "harvester",
            pixelWidth: 40,
            pixelHeight: 60,
            baseWidth: 40,
            baseHeight: 20,
            pixelOffsetX: -2,
            pixelOffsetY: 40,
            buildableGrid: [
                [1, 1]
            ],
            passableGrid: [
                [1, 1]
            ],
            sight: 3,
            cost: 5000,
            hitPoints: 300,
            spriteImages: [
                { name: "deploy", count: 17 },
                { name: "healthy", count: 3 },
                { name: "damaged", count: 1 }
            ],
        },

        "ground-turret": {
            name: "ground-turret",
            canAttack: true,
            canAttackLand: true,
            canAttackAir: false,
            weaponType: "cannon-ball",
            action: "stand",
            direction: 0, // Domyślnie kierujemy działko ku górze (0)
            directions: 8, // Możemy mieć 8 kierunków działka (0-7)
            orders: { type: "guard" },
            pixelWidth: 38,
            pixelHeight: 32,
            baseWidth: 20,
            baseHeight: 18,
            cost: 1500,
            canConstruct: true,
            pixelOffsetX: 9,
            pixelOffsetY: 12,
            buildableGrid: [
                [1]
            ],
            passableGrid: [
                [1]
            ],
            sight: 5,
            hitPoints: 200,
            spriteImages: [
                { name: "teleport", count: 9 },
                { name: "healthy", count: 1, directions: 8 },
                { name: "damaged", count: 1 }
            ],
        }
    },

    defaults: {
        type: "buildings",

        processActions: function() {
            switch (this.action) {

                case "stand":
                    if (this.name === "ground-turret" && this.lifeCode === "healthy") {
                        // W przypadku działka o dobrej kondycji korzystamy ze zmiennej direction, aby wybrać listę obrazów
                        let direction = Math.round(this.direction) % this.directions;

                        this.imageList = this.spriteArray[this.lifeCode + "-" + direction];
                    } else {
                        // W pozostałych przypadkach korzystamy ze zmiennej lifeCode
                        this.imageList = this.spriteArray[this.lifeCode];
                    }

                    this.imageOffset = this.imageList.offset + this.animationIndex;
                    this.animationIndex++;

                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                    }

                    break;
                case "construct":
                    this.imageList = this.spriteArray["constructing"];
                    this.imageOffset = this.imageList.offset + this.animationIndex;
                    this.animationIndex++;

                    // Gdy konstrukcja jest gotowa, wracamy do pozycji spoczynkowej
                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                        this.action = "stand";
                    }

                    break;

                case "teleport":
                    this.imageList = this.spriteArray["teleport"];
                    this.imageOffset = this.imageList.offset + this.animationIndex;
                    this.animationIndex++;

                    // Po zakończeniu teleportowania przechodzimy do trybu stand
                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                        this.action = "stand";
                    }

                    break;

                case "close":
                    this.imageList = this.spriteArray["closing"];
                    this.imageOffset = this.imageList.offset + this.animationIndex;
                    this.animationIndex++;

                    // Po zakończeniu zamykania powracamy do trybu stand
                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                        this.action = "stand";
                    }

                    break;

                case "open":
                    this.imageList = this.spriteArray["closing"];
                    // Otwieranie polega na odtworzeniu sprite’ów zamykania, tylko w odwrotnej kolejności 
                    this.imageOffset = this.imageList.offset + this.imageList.count - this.animationIndex;
                    this.animationIndex++;

                    // Po zakończeniu otwierania przechodzimy do trybu close
                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                        this.action = "close";
                    }

                    break;

                case "deploy":
                    this.imageList = this.spriteArray["deploy"];
                    this.imageOffset = this.imageList.offset + this.animationIndex;
                    this.animationIndex++;

                    // Po rozlokowaniu obiektu przechodzimy do stanu spoczynku 
                    if (this.animationIndex >= this.imageList.count) {
                        this.animationIndex = 0;
                        this.action = "stand";
                    }

                    break;
            }
        },

        // Domyślna funkcja służąca do rysowania budynku
        drawSprite: function() {
            let x = this.drawingX;
            let y = this.drawingY;

            // We wszystkich arkuszach sprite’ów obrazy dla zespołu niebieskiego znajdują się w pierwszym rzędzie, a dla zielonego w drugim 
            let colorIndex = (this.team === "blue") ? 0 : 1;
            let colorOffset = colorIndex * this.pixelHeight;

            // Rysujemy sprite w punkcie x, y
            game.foregroundContext.drawImage(this.spriteSheet, this.imageOffset * this.pixelWidth, colorOffset, this.pixelWidth, this.pixelHeight, x, y, this.pixelWidth, this.pixelHeight);
        },

        drawLifeBar: function() {
            let x = this.drawingX + this.pixelOffsetX;
            let y = this.drawingY - 2 * this.lifeBarHeight;

            game.foregroundContext.fillStyle = (this.lifeCode === "healthy") ? this.lifeBarHealthyFillColor : this.lifeBarDamagedFillColor;

            game.foregroundContext.fillRect(x, y, this.baseWidth * this.life / this.hitPoints, this.lifeBarHeight);

            game.foregroundContext.strokeStyle = this.lifeBarBorderColor;
            game.foregroundContext.lineWidth = 1;

            game.foregroundContext.strokeRect(x, y, this.baseWidth, this.lifeBarHeight);
        },

        drawSelection: function() {
            let x = this.drawingX + this.pixelOffsetX;
            let y = this.drawingY + this.pixelOffsetY;

            game.foregroundContext.strokeStyle = this.selectionBorderColor;
            game.foregroundContext.lineWidth = 1;
            game.foregroundContext.fillStyle = this.selectionFillColor;

            // Rysujemy wypełniony prostokąt wokół budynku 
            game.foregroundContext.fillRect(x - 1, y - 1, this.baseWidth + 2, this.baseHeight + 2);
            game.foregroundContext.strokeRect(x - 1, y - 1, this.baseWidth + 2, this.baseHeight + 2);
        },
    },

    load: loadItem,
    add: addItem,

};
