/* Szczegóły map wykorzystywanych w poziomach */
var maps = {
    "plains": {
        "mapImage": "plains-debug.png",

        /* Dane terenu automatycznie wygenerowane przez plik level/convert-levels.js */
        "mapGridWidth": 60,
        "mapGridHeight": 40,
        "mapObstructedTerrain": [[0, 0], [1, 0], [2, 0], [26, 0], [27, 0], [28, 0], [29, 0], [30, 0], [31, 0], [32, 0], [33, 0], [44, 0], [45, 0], [46, 0], [47, 0], [48, 0], [49, 0], [50, 0], [51, 0], [52, 0], [53, 0], [54, 0], [55, 0], [56, 0], [58, 0], [59, 0], [0, 1], [1, 1], [2, 1], [25, 1], [26, 1], [27, 1], [28, 1], [29, 1], [30, 1], [31, 1], [32, 1], [45, 1], [46, 1], [47, 1], [48, 1], [49, 1], [50, 1], [51, 1], [52, 1], [53, 1], [54, 1], [55, 1], [56, 1], [58, 1], [59, 1], [12, 2], [13, 2], [14, 2], [25, 2], [26, 2], [27, 2], [28, 2], [29, 2], [30, 2], [31, 2], [45, 2], [46, 2], [47, 2], [48, 2], [49, 2], [50, 2], [51, 2], [52, 2], [53, 2], [54, 2], [55, 2], [56, 2], [58, 2], [59, 2], [10, 3], [11, 3], [12, 3], [13, 3], [14, 3], [25, 3], [26, 3], [27, 3], [29, 3], [30, 3], [31, 3], [47, 3], [48, 3], [49, 3], [50, 3], [51, 3], [52, 3], [53, 3], [54, 3], [55, 3], [58, 3], [59, 3], [10, 4], [11, 4], [12, 4], [13, 4], [14, 4], [15, 4], [48, 4], [49, 4], [50, 4], [51, 4], [52, 4], [53, 4], [58, 4], [59, 4], [10, 5], [11, 5], [12, 5], [13, 5], [14, 5], [15, 5], [48, 5], [49, 5], [50, 5], [51, 5], [58, 5], [59, 5], [13, 6], [14, 6], [15, 6], [49, 6], [50, 6], [51, 6], [52, 6], [53, 6], [54, 6], [58, 6], [59, 6], [15, 7], [19, 7], [49, 7], [50, 7], [51, 7], [52, 7], [53, 7], [54, 7], [58, 7], [59, 7], [32, 8], [33, 8], [34, 8], [49, 8], [50, 8], [51, 8], [52, 8], [53, 8], [54, 8], [58, 8], [59, 8], [3, 9], [4, 9], [5, 9], [32, 9], [33, 9], [34, 9], [49, 9], [50, 9], [51, 9], [52, 9], [53, 9], [58, 9], [59, 9], [3, 10], [4, 10], [5, 10], [6, 10], [7, 10], [8, 10], [9, 10], [11, 10], [12, 10], [13, 10], [32, 10], [33, 10], [34, 10], [49, 10], [50, 10], [51, 10], [52, 10], [53, 10], [58, 10], [59, 10], [3, 11], [4, 11], [5, 11], [6, 11], [7, 11], [8, 11], [9, 11], [10, 11], [11, 11], [12, 11], [13, 11], [49, 11], [50, 11], [51, 11], [52, 11], [53, 11], [58, 11], [59, 11], [5, 12], [6, 12], [7, 12], [8, 12], [9, 12], [10, 12], [11, 12], [12, 12], [13, 12], [29, 12], [48, 12], [49, 12], [50, 12], [51, 12], [52, 12], [53, 12], [5, 13], [6, 13], [7, 13], [30, 13], [34, 13], [35, 13], [36, 13], [48, 13], [49, 13], [50, 13], [51, 13], [52, 13], [53, 13], [5, 14], [6, 14], [7, 14], [20, 14], [21, 14], [34, 14], [35, 14], [36, 14], [48, 14], [49, 14], [50, 14], [51, 14], [52, 14], [53, 14], [34, 15], [35, 15], [36, 15], [49, 15], [50, 15], [51, 15], [52, 15], [53, 15], [47, 16], [48, 16], [49, 16], [50, 16], [51, 16], [52, 16], [53, 16], [44, 17], [47, 17], [48, 17], [49, 17], [50, 17], [51, 17], [52, 17], [16, 18], [17, 18], [18, 18], [47, 18], [48, 18], [49, 18], [50, 18], [51, 18], [52, 18], [9, 19], [10, 19], [11, 19], [16, 19], [17, 19], [18, 19], [43, 19], [44, 19], [45, 19], [46, 19], [47, 19], [48, 19], [50, 19], [51, 19], [52, 19], [9, 20], [10, 20], [11, 20], [16, 20], [17, 20], [18, 20], [43, 20], [44, 20], [45, 20], [46, 20], [47, 20], [48, 20], [9, 21], [10, 21], [11, 21], [24, 21], [25, 21], [26, 21], [30, 21], [31, 21], [32, 21], [43, 21], [44, 21], [45, 21], [46, 21], [47, 21], [48, 21], [24, 22], [25, 22], [26, 22], [27, 22], [28, 22], [29, 22], [30, 22], [31, 22], [32, 22], [41, 22], [42, 22], [43, 22], [44, 22], [45, 22], [46, 22], [47, 22], [48, 22], [49, 22], [50, 22], [24, 23], [25, 23], [26, 23], [27, 23], [28, 23], [29, 23], [30, 23], [31, 23], [32, 23], [41, 23], [42, 23], [43, 23], [44, 23], [45, 23], [46, 23], [47, 23], [48, 23], [49, 23], [50, 23], [25, 24], [26, 24], [27, 24], [28, 24], [29, 24], [41, 24], [42, 24], [43, 24], [44, 24], [45, 24], [46, 24], [47, 24], [48, 24], [49, 24], [50, 24], [2, 25], [3, 25], [4, 25], [24, 25], [25, 25], [26, 25], [27, 25], [28, 25], [29, 25], [43, 25], [44, 25], [45, 25], [46, 25], [47, 25], [2, 26], [3, 26], [4, 26], [24, 26], [25, 26], [26, 26], [27, 26], [28, 26], [29, 26], [43, 26], [44, 26], [45, 26], [46, 26], [47, 26], [2, 27], [3, 27], [4, 27], [24, 27], [25, 27], [26, 27], [27, 27], [28, 27], [29, 27], [43, 27], [44, 27], [45, 27], [46, 27], [47, 27], [25, 28], [26, 28], [27, 28], [28, 28], [29, 28], [43, 28], [44, 28], [45, 28], [46, 28], [47, 28], [54, 28], [8, 29], [9, 29], [23, 29], [24, 29], [25, 29], [26, 29], [27, 29], [28, 29], [29, 29], [43, 29], [44, 29], [45, 29], [46, 29], [47, 29], [59, 29], [9, 30], [23, 30], [24, 30], [25, 30], [26, 30], [27, 30], [28, 30], [43, 30], [44, 30], [45, 30], [46, 30], [47, 30], [59, 30], [23, 31], [24, 31], [25, 31], [26, 31], [27, 31], [28, 31], [36, 31], [59, 31], [17, 32], [18, 32], [19, 32], [25, 32], [26, 32], [27, 32], [28, 32], [46, 32], [55, 32], [59, 32], [17, 33], [18, 33], [19, 33], [23, 33], [24, 33], [25, 33], [26, 33], [27, 33], [28, 33], [33, 33], [34, 33], [35, 33], [59, 33], [17, 34], [18, 34], [19, 34], [23, 34], [24, 34], [25, 34], [26, 34], [27, 34], [28, 34], [33, 34], [34, 34], [35, 34], [59, 34], [23, 35], [24, 35], [25, 35], [26, 35], [27, 35], [28, 35], [33, 35], [34, 35], [35, 35], [59, 35], [24, 36], [25, 36], [26, 36], [27, 36], [28, 36], [59, 36], [22, 37], [23, 37], [24, 37], [25, 37], [26, 37], [27, 37], [28, 37], [59, 37], [22, 38], [23, 38], [24, 38], [25, 38], [26, 38], [27, 38], [59, 38], [22, 39], [23, 39], [24, 39], [25, 39], [26, 39], [27, 39], [48, 39], [49, 39], [50, 39], [51, 39], [52, 39], [53, 39], [54, 39], [55, 39], [56, 39], [57, 39], [58, 39], [59, 39]],
    }
};

/* Rzeczywiste poziomy gry */
var levels = {
    "singleplayer": [
        {
            "name": "Poruszanie się",
        
            "briefing": "W tym poziomie zaczniesz wydawać jednostkom polecenia i przesuwać je na mapie.",

            /* Szczegóły mapy */
            "mapName": "plains",

            /* Początkowe położenie gracza */
            "startX": 0,
            "startY": 0,

            /* Encje, które należy wczytać */
            "requirements": {
                "buildings": ["base", "starport", "harvester", "ground-turret"],
                "vehicles": ["transport", "harvester", "scout-tank", "heavy-tank"],
                "aircraft": ["chopper", "wraith"],
                "terrain": ["oilfield", "bigrocks", "smallrocks"]
            },

            /* Encje, które należy dodać */
            "items": [
                { "type": "buildings", "name": "base", "x": 11, "y": 14, "team": "blue" },
                { "type": "buildings", "name": "starport", "x": 18, "y": 14, "team": "blue" },

                { "type": "vehicles", "name": "harvester", "x": 16, "y": 12, "team": "blue", "direction": 3, "uid": -1 },
                { "type": "terrain", "name": "oilfield", "x": 3, "y": 5, "action": "hint" },

                { "type": "terrain", "name": "bigrocks", "x": 19, "y": 6 },
                { "type": "terrain", "name": "smallrocks", "x": 8, "y": 3 }
            ],

            /* Aspekt finansowy */
            "cash": {
                "blue": 5000,
                "green": 1000
            },

            /* Warunkowe i czasowe zdarzenia wyzwalaczy */
            "triggers": [
                /* Zdarzenia czasowe */
                {
                    "type": "timed",
                    "time": 1000,
                    "action": function() {
                        game.showMessage("system", "Pozostało 20 sekund.\nPrzenieś kombajn w pobliże pola naftowego.");
                    }
                },
                {
                    "type": "timed",
                    "time": 21000,
                    "action": function() {
                        singleplayer.endLevel(false);
                    }
                },
                /* Zdarzenie warunkowe */
                {
                    "type": "conditional",
                    "condition": function() {
                        let transport = game.getItemByUid(-1);

                        // True, jeśli transport osiągnie górny lewy kafelek obok pola naftowego
                        return (transport.x < 7 && transport.y < 7);
                    },
                    "action": function() {
                        singleplayer.endLevel(true);
                    }
                }
            ],
        }
    ],

    "multiplayer": [

    ]
};


