var game = {

    // Zaczynamy inicjalizowanie obiektów, wczytujemy zasoby i wyświetlamy ekran powitalny
    init: function() {
        // Inicjalizujemy obiekty
        loader.init();
        mouse.init();

        // Inicjalizujemy i zapisujemy konteksty obydwu elementów canvas 
        game.initCanvases();

        // Wyświetlamy główne menu gry
        game.hideScreens();
        game.showScreen("gamestartscreen");
    },

    canvasWidth: 480,
    canvasHeight: 400,

    initCanvases: function() {
        game.backgroundCanvas = document.getElementById("gamebackgroundcanvas");
        game.backgroundContext = game.backgroundCanvas.getContext("2d");

        game.foregroundCanvas = document.getElementById("gameforegroundcanvas");
        game.foregroundContext = game.foregroundCanvas.getContext("2d");

        game.foregroundCanvas.width = game.canvasWidth;
        game.backgroundCanvas.width = game.canvasWidth;

        game.foregroundCanvas.height = game.canvasHeight;
        game.backgroundCanvas.height = game.canvasHeight;
    },

    hideScreens: function() {
        var screens = document.getElementsByClassName("gamelayer");

        // Iterujemy wszystkie warstwy gry i wyłączamy ich wyświetlanie 
        for (let i = screens.length - 1; i >= 0; i--) {
            let screen = screens[i];

            screen.style.display = "none";
        }
    },

    hideScreen: function(id) {
        var screen = document.getElementById(id);

        screen.style.display = "none";
    },

    showScreen: function(id) {
        var screen = document.getElementById(id);

        screen.style.display = "block";
    },

    scale: 1,
    resize: function() {

        var maxWidth = window.innerWidth;
        var maxHeight = window.innerHeight;

        var scale = Math.min(maxWidth / 640, maxHeight / 480);

        var gameContainer = document.getElementById("gamecontainer");

        gameContainer.style.transform = "translate(-50%, -50%) " + "scale(" + scale + ")";

        game.scale = scale;

        // Znajdujemy maksymalną szerokość na podstawie bieżącej skali 
        // i wybieramy wartość spomiędzy 640 i 1024
        var width = Math.max(640, Math.min(1024, maxWidth / scale ));

        // Przypisujemy nową szerokość do kontenera gry i obiektu canvas gry
        gameContainer.style.width = width + "px";

        // Odejmujemy 160 pikseli na potrzeby paska bocznego
        var canvasWidth = width - 160;

        // Ustawiamy flagę w przypadku zmiany rozmiaru elementu canvas
        if (game.canvasWidth !== canvasWidth) {
            game.canvasWidth = canvasWidth;
            game.canvasResized = true;
        }

    },

    loadLevelData: function(level) {
        game.currentLevel = level;
        game.currentMap = maps[level.mapName];

        // Wczytujemy wszystkie zasoby poziomu, zaczynając od obrazu mapy
        game.currentMapImage = loader.loadImage("images/maps/" + maps[level.mapName].mapImage);
    },

    start: function() {
        // Wyświetlamy interfejs gry
        game.hideScreens();
        game.showScreen("gameinterfacescreen");

        game.running = true;
        game.refreshBackground = true;
        game.canvasResized = true;

        game.drawingLoop();
    },

    // Pętla sterowania działająca przez ustalony okres
	animationTimeout: 100, // 100 millisekund, czyli 10 razy na sekundę

    animationLoop: function() {

    },

    // Mapa jest podzielona na kwadratowe kafelki o tym rozmiarze (20 x 20 pikseli)
    gridSize: 20,
    // Współrzędne X i Y przesunięcia mapy
    offsetX: 0,
    offsetY: 0,

    drawingLoop: function() {
        // Przesuwamy mapę, jeśli kursor znajduje się w pobliżu krawędzi obiektu canvas
        game.handlePanning();

        // Rysujemy tło, zawsze gdy jest potrzebne 
        game.drawBackground();

        // Wywołujemy pętlę rysowania dla następnej klatki za pomocą żądania klatki animacji 
        if (game.running) {
            requestAnimationFrame(game.drawingLoop);
        }
    },

    drawBackground: function() {
        // Ponieważ rysowanie mapy tła jest kosztowną operacją,
        // przerysowujemy tło, tylko jeśli się zmieni (ze względu na przesuwanie lub zmianę rozmiaru)
        if (game.refreshBackground || game.canvasResized) {
            if (game.canvasResized) {
                game.backgroundCanvas.width = game.canvasWidth;
                game.foregroundCanvas.width = game.canvasWidth;

                // Upewniamy się, że zmiana rozmiaru nie spowoduje przesunięcia mapy poza jej granice
                if (game.offsetX + game.canvasWidth > game.currentMapImage.width) {
                    game.offsetX = game.currentMapImage.width - game.canvasWidth;
                }

                if (game.offsetY + game.canvasHeight > game.currentMapImage.height) {
                    game.offsetY = game.currentMapImage.height - game.canvasHeight;
                }

                game.canvasResized = false;
            }

            game.backgroundContext.drawImage(game.currentMapImage, game.offsetX, game.offsetY, game.canvasWidth, game.canvasHeight, 0, 0, game.canvasWidth, game.canvasHeight);
            game.refreshBackground = false;
        }
    },

    // Odległość od krawędzi obiektu canvas, w miejscu rozpoczęcia przesuwania 
    panningThreshold: 80,
    // Maksymalna odległość przesuwania w jednej pętli rysowania 

    maximumPanDistance: 10,

    handlePanning: function() {

        // Nie przesuwamy, jeśli mysz znajdzie się poza obiektem canvas 
        if (!mouse.insideCanvas) {
            return;
        }


        if (mouse.x <= game.panningThreshold) {
            // Kursor myszy znajduje się na lewej krawędzi obszaru gry. Przesuwamy w lewo.
            let panDistance = game.offsetX;

            if (panDistance > 0) {
                game.offsetX -= Math.min(panDistance, game.maximumPanDistance);
                game.refreshBackground = true;
            }
        } else if (mouse.x >= game.canvasWidth - game.panningThreshold) {
            // Kursor myszy znajduje się na prawej krawędzi obszaru gry. Przesuwamy w prawo.
            let panDistance = game.currentMapImage.width - game.canvasWidth - game.offsetX;

            if (panDistance > 0) {
                game.offsetX += Math.min(panDistance, game.maximumPanDistance);
                game.refreshBackground = true;
            }
        }

        if (mouse.y <= game.panningThreshold) {
            // Kursor myszy znajduje się na górnej krawędzi obszaru gry. Przesuwamy w górę.
            let panDistance = game.offsetY;

            if (panDistance > 0) {
                game.offsetY -= Math.min(panDistance, game.maximumPanDistance);
                game.refreshBackground = true;
            }
        } else if (mouse.y >= game.canvasHeight - game.panningThreshold) {
            // Kursor myszy znajduje się na dolnej krawędzi obszaru gry. Przesuwamy w dół.
            let panDistance = game.currentMapImage.height - game.offsetY - game.canvasHeight;

            if (panDistance > 0) {
                game.offsetY += Math.min(panDistance, game.maximumPanDistance);
                game.refreshBackground = true;
            }
        }

        if (game.refreshBackground) {
            // Uaktualniamy współrzędne kursora myszy na podstawie nowych wartości gry offsetX i offsetY
            mouse.calculateGameCoordinates();
        }
    },
};

/* Konfiguracja funkcji obsługi zdarzeń w oknie początkowym  */

// Inicjalizujemy grę i zmieniamy jej rozmiar dopiero po całkowitym wczytaniu strony
window.addEventListener("load", function() {
    game.resize();
    game.init();
}, false);

// Zmiana rozmiaru gry po zmianie rozmiaru okna 
window.addEventListener("resize", function() {
    game.resize();
});