var loader = {
    loaded: true,
    loadedCount: 0, // Zasoby, które zostały dotychczas wczytane 
    totalCount: 0, // Całkowita liczba zasobów, które oczekują na wczytanie

    init: function() {
        // Sprawdzamy wsparcie dla zasobów dźwiękowych
        var mp3Support, oggSupport;
        var audio = document.createElement("audio");

        if (audio.canPlayType) {
               // Obecnie metoda canPlayType() zwraca: "", "maybe" lub "probably"
            mp3Support = "" !== audio.canPlayType("audio/mpeg");
            oggSupport = "" !== audio.canPlayType("audio/ogg; codecs=\"vorbis\"");
        } else {
            //Brak wsparcia dla znacznika audio
            mp3Support = false;
            oggSupport = false;
        }

        // Sprawdzamy wsparcie formatu ogg, następnie mp3, a w razie niepowodzenia ustawiamy wartość zmiennej soundFileExtn na undefined
        loader.soundFileExtn = oggSupport ? ".ogg" : mp3Support ? ".mp3" : undefined;
    },

    loadImage: function(url) {
        this.loaded = false;
        this.totalCount++;

        game.showScreen("loadingscreen");

        var image = new Image();

        image.addEventListener("load", loader.itemLoaded, false);
        image.src = url;

        return image;
    },

    soundFileExtn: ".ogg",

    loadSound: function(url) {
        this.loaded = false;
        this.totalCount++;

        game.showScreen("loadingscreen");

        var audio = new Audio();

        audio.addEventListener("canplaythrough", loader.itemLoaded, false);
        audio.src = url + loader.soundFileExtn;

        return audio;
    },

    itemLoaded: function(ev) {
        // Przestajemy oczekiwać na typ zdarzenia (load lub canplaythrough) dla elementu, który został już wczytany
        ev.target.removeEventListener(ev.type, loader.itemLoaded, false);

        loader.loadedCount++;

        document.getElementById("loadingmessage").innerHTML = "Loaded " + loader.loadedCount + " of " + loader.totalCount;

        if (loader.loadedCount === loader.totalCount) {
            // Wczytywanie zostało zakończone
            // Resetujemy i czyścimy obiekt wczytujący
            loader.loaded = true;
            loader.loadedCount = 0;
            loader.totalCount = 0;

            // Ukrywamy ekran wczytywania
            game.hideScreen("loadingscreen");

            //i wywołujemy metodę loader.onload, o ile istnieje 
            if (loader.onload) {
                loader.onload();
                loader.onload = undefined;
            }
        }
    }
};
