<!DOCTYPE html>
<!--
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
-->
<html lang="pl">
  <head>
    <meta charset="utf-8">
    <title>Sklep internetowy</title>
    <link href="//netdna.bootstrapcdn.com/bootswatch/2.3.0/united/bootstrap.min.css" rel="stylesheet">
    <script src="//netdna.bootstrapcdn.com/twitter-bootstrap/2.3.1/js/bootstrap.min.js"></script>
    <style type="text/css">
      body{
        margin : 5px;
      }
      a {
        font-weight:bold;
      }
    </style>
  </head>
  <body>
    <div class='container'>
      <div class="navbar">
        <div class="navbar-inner">
          <a class="brand" href="#">Sklep internetowy</a>
          <ul class="nav">
            <li class="active"><a href="index.php">Strona główna sklepu</a></li>
            <li class="active"><a href="index.php?action=showbasket">Zawartość koszyka</a></li>
          </ul>
        </div>
      </div>
      <?php
        if($message):
      ?>
      <div class="alert" id="messagepart">
        <?php echo $message; ?>
      </div>
      <?php
        endif;
      ?>
      <div id='mainpart' class='well'>
        <div style="min-height:30px">
          <?php if($display == 'main'): 
                  $btnName = "Kup";
                  $action = "addtobasket";
          ?>
            Witamy w naszym sklepie internetowym.
          <?php else:
                  $btnName = "Zmień";
                  $action = "modifybasket";
          ?>
            Zawartość koszyka.
          <?php endif;?>
        </div>
        <div>
          <?php if(count($towary)): ?>
            <table class="table">
            <tr>
              <th>Nazwa towaru</th><th>Cena</th><th>Liczba sztuk</th>
            </tr>
            <?php foreach($towary as $towar): ?>
              <tr>
                <td><?=$towar['Nazwa']?></td>
                <td><?=$towar['Cena']?></td>
                <td>
                  <form action="index.php?action=<?=$action?>" method="post" class="form-inline">
                  <input type="text" name="sztuk" value="<?=$towar['Sztuk']?>" class="input-small">
                  <input type="submit" class="btn" value="<?=$btnName?>">
                  <input type="hidden" name="itemid" 
                         value="<?=$towar['Id']?>">
                  <input type="hidden" name="nazwa" 
                         value="<?=$towar['Nazwa']?>">
                  <input type="hidden" name="cena" 
                         value="<?=$towar['Cena']?>">
                  </form>
                </td>
              </tr>
            <?php endforeach;?>
            </table>
            <?php if($display == 'basket'): ?>
            <form action="index.php?action=saveorder" method="post" >
              <label for="adres">Podaj dane adresowe</label>
              <textarea name="adres"></textarea>
              <input type="submit" value="Złóż zamówienie" class="btn">
            </form>
            <?php else: ?>
              <a href="index.php?action=showbasket" class="btn"
                >Przejdź do koszyka i złóż zamówienie</a>
            <?php endif; ?>
          <?php else:?>
            Brak towarów.
          <?php endif;?>
        </div>
      </div>
      
      <div id='footerpart'>
      </div>
    </div>
  </body>
</html>
