<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $filespath = '/var/www/files/';
  
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zaptyań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  function getFilesList()
  {
    //$files = array();
    $query = "SELECT Id, Nazwa FROM files";

    if(!($result = $this->dbo->query($query)) || !($rows = $result->fetchAll())){
      return array();
    }
    return $rows;
    //return $files;
  }
  function getFile()
  {
    if(!isset($_REQUEST['id'])){
      $this->setMessage('Nieprawidłowe wywołanie.');
      return ACTION_FAILED;
    }
    
    $id = intval($_REQUEST['id']);
    
    $query = "SELECT Nazwa FROM files WHERE id = $id";

    if(!($result = $this->dbo->query($query)) || !($row = $result->fetch())){
      $this->setMessage('Brak wskazanego pliku.');
      return ACTION_FAILED;
    }
    
    $filename = $row[0];
    
    $fullfilename = $this->filespath.$filename;
    
    if(!file_exists($fullfilename)){
      $this->setMessage('Brak wskazanego pliku.');
      return ACTION_FAILED;
    }
    
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename='.$filename);
    header('Content-Length: ' . filesize($fullfilename));
    readfile($fullfilename);
  }
  function showMain()
  {
    $message = $this->getMessage();
    $files = $this->getFilesList();
    include 'tmpl/main.tpl.php';
  }
  
  function update_files_list()
  {
    $query  = "INSERT INTO files (Nazwa) VALUES (:Nazwa)";
    
    if(!($stm = $this->dbo->prepare($query))){
      $this->setMessage("Wystąpił błąd serwera.");
      return ACTION_FAILED;
    }
    $count = 0;
    if($dir = scandir($this->filespath)){
      foreach($dir as $file){
        if(is_file($this->filespath.$file)){
          if($stm->execute(array('Nazwa'=>$file)) && 
             $stm->rowCount()){
            $count++;
          }
        }
      }
    }
    $this->setMessage("Liczba dodanych wierszy: $count");
    return ACTION_OK;
  }
}

?>