<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    setcookie('message', $msg);
  }
  function getMessage()
  {
    if(isset($_COOKIE['message'])){
      $message = $_COOKIE['message'];
      setcookie('message', '');
      return $message;
    }
    return false;
  }
  function login()
  {
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Id, Nazwa, Haslo FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->rowCount() == 1){
      $row = $result->fetch();
      //if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
      //hasła niekodowane dla łatwiejszej manipulacji danymi w bazie
      if($row && $row['Haslo'] == $pass){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        setcookie('zalogowany', '1');
        setcookie('userid', $row['Id']);
        
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        $this->setMessage('Nieprawidłowa nazwa lub hasło.');
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  
  function logout()
  {
    if(isset($_COOKIE['zalogowany'])){
      setcookie('zalogowany', '');
      $this->setMessage('Wylogowanie prawidłowe.');
    }
    else{
      $this->setMessage('Najpierw się zaloguj.');
    }
  }
  
  function loginCheck()
  {
    if(isset($_COOKIE['zalogowany']) && $_COOKIE['zalogowany'] == '1'){
      return true;
    }
    else{
      return false;
    }
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    $zalogowany = $this->loginCheck();
    include 'tmpl/main.tpl.php';
  }
}

?>