<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("ACTION_OK", 1);
define("ACTION_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query  = "SELECT * FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if(($rows = $result->fetchAll()) && count($rows) == 1){
      $row = $rows[0];
      
      if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        $_SESSION['zalogowany'] = $row['Nazwa'];
        
        //Zapisanie daty ostatniego prawidłowego logowania
        if($row['ZleLogowania']){
          $query  = "UPDATE Users SET PrawidloweLogowanie = NOW() "; 
          $query .= "WHERE Id = {$row['Id']}";
          if(!$this->dbo->exec($query)){
            //Błąd przy aktualizacji danych
          }
        }
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        
        //Zapisanie daty ostatniego prawidłowego logowania
        $query  = "UPDATE Users SET NieprawidloweLogowanie = NOW() ";
        $query .= "WHERE id = {$row['Id']}";

        if(!$this->dbo->exec($query)){
          //Błąd przy aktualizacji danych
        }
        $this->setMessage('Nieprawidłowa nazwa lub hasło.');
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      $goodLogin = 'brak danych';
      $badLogin = 'brak danych';
      
      $query  = "SELECT PrawidloweLogowanie, NieprawidloweLogowanie ";
      $query .= "FROM Users WHERE Nazwa='{$_SESSION['zalogowany']}'";

      if(($result = $this->dbo->query($query)) && 
         ($row = $result->fetch())){
        $goodLogin = $row[0];
        $badLogin = $row[1];
      }
      include 'tmpl/main.tpl';
    }
    else{
      $formMsg = 'Musisz się zalogować:';
      $btnMsg = 'Zaloguj';
      $formAction = 'index.php?action=login';
      include 'tmpl/form.tpl';
    }
  }
}

?>