<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
define("ACTION_OK", 1);
define("ACTION_FAILED", 2);
define("SERVER_ERROR", 3);
 
class Site
{
  private $dbo = null;
  function initDB($host, $user, $pass, $db)
  {
    $this->dbo = new mysqli($host, $user, $pass, $db);
    if($this->dbo->connect_errno){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $this->dbo->connect_error;
      throw new Exception($msg);
    }
  }
  function addUser()
  {
    if(!isset($_SESSION['zalogowany'])){
      $this->setMessage('Najpierw musisz się zalogwać.');
      return ACTION_FAILED;
    }
  
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Podaj nazwę i hasło dodawanego użytkownika.');
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["pass"];
    
    //Tutaj dodatkowo zweryfikuj poprawność nazwy i hasła
    
    $pass = crypt($pass);
    
    //Utworzenie zapytania - tu nadal występuje błąd SQL Injection
    $query = "INSERT INTO Users (Nazwa, Haslo) VALUES";
    $query .= "('$user', '$pass')";
    
    //Wykonanie zapytania dodajacego użytkownika
    if(!$this->dbo->query($query)){
      $this->setMessage("
        Dodanie użytkownika '$user' nie jest możliwe. {$this->dbo->error}");
      return ACTION_FAILED;
    }
    
    //Sprawdzenie wyników zapytania.
    if($this->dbo->insert_id){
      $this->setMessage(
        "Użytkownik '$user' został dodany. Id = {$this->dbo->insert_id}.");
      return ACTION_OK;
    }
    else{
      $this->setMessage(
        "Użytkownik nie został dodany. {$this->dbo->error}");
      return ACTION_FAILED;
    }
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return LOGIN_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Haslo, Nazwa, Id ";
    $query .= "FROM Users WHERE Nazwa='$user'";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->num_rows == 1){
      $row = $result->fetch_row();
      if($row && $row[0] == crypt($pass, $row[0])){
        $this->setMessage("Jesteś zalogowany jako {$row[1]}.");
        $_SESSION['zalogowany'] = $row[1];
        return LOGIN_OK;
      }
      else{
        $this->setMessage('Nieprawidłowa nazwa lub hasło.');
        return LOGIN_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return LOGIN_FAILED;
    }
  }
  
  function logout()
  {
    unset($_SESSION['zalogowany']);
    header('Location:index.php');
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function showMain()
  {
    if(isset($_SESSION['zalogowany'])){
      include 'tmpl/main.tpl';
    }
    else{
      $formMsg = 'Musisz się zalogować:';
      $btnMsg = 'Zaloguj';
      $formAction = 'index.php?action=login';
      include 'tmpl/form.tpl';
    }
  }
  function showAddUser()
  {
    if(isset($_SESSION['zalogowany'])){
      $formMsg = 'Podaj nazwę konta i hasło:';
      $btnMsg = 'Dodaj użytkownika';
      $formAction = 'index.php?action=adduser';
      include 'tmpl/form.tpl';
    }
    else{
      $this->showMain();
    }
  }
}

?>