<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function addPost()
  {
    if(!(isset($_POST['autor']) && ($autor = $_POST['autor']) &&
       isset($_POST['tresc']) && ($tresc = $_POST['tresc']))){
      $this->setMessage("Proszę podać poprawne dane.");
      return ACTION_FAILED;
    }
    
    //tu można wykonać dodatkową weryfikację poprawności danych
    
    $query  = "INSERT INTO posts (autor,tresc) ";
    $query .= "VALUES (:autor, :tresc)";
    
    if(!(($stm = $this->dbo->prepare($query)) && 
       ($stm->execute(array('autor'=>$autor, 'tresc'=>$tresc))))){
      $this->setMessage("Wystąpił błąd serwera.");
      return ACTION_FAILED;
    }
    $this->setMessage("Wpis został dodany.");
    return ACTION_OK;
  }
  function getPosts($count)
  {
    $query  = "SELECT autor, tresc, data FROM posts ";
    if($count > 0){
      $query .= "ORDER BY data DESC LIMIT $count";
    }
    else{
      $query .= "ORDER BY data DESC";
    }
    if(($result = $this->dbo->query($query)) && 
       ($rows = $result->fetchAll(PDO::FETCH_ASSOC))){
       return $rows;
    }
    else{
      return array();
    }
  }
  function showMain()
  {
    $postsdata = $this->getPosts(5);
    include 'tmpl/main.tpl.php';
  }
}

?>