<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zaptyań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function deleteMessage()
  {
    if(isset($_SESSION['message'])){
      unset($_SESSION['message']);
    }
  }
  function addToGuestbook()
  {
    if(!(isset($_POST['autor']) && ($autor = $_POST['autor']) &&
       isset($_POST['tresc']) && ($tresc = $_POST['tresc']))){
      $this->setMessage("Proszę podać poprawne dane.");
      return ACTION_FAILED;
    }
    
    //tu można wykonać dodatkową weryfikację poprawności danych
    
    $query  = "INSERT INTO guestbook (autor,tresc) ";
    $query .= "VALUES (:autor, :tresc)";
    
    if(!(($stm = $this->dbo->prepare($query)) && 
        $stm->execute(array('autor'=>$autor, 'tresc'=>$tresc)))){
      $this->setMessage("Wystąpił błąd serwera.");
      return ACTION_FAILED;
    }
    $this->setMessage("Wpis został dodany do księgi gości.");
    return ACTION_OK;
  }
  function getGuestbookItems($count)
  {
    $query  = "SELECT autor, tresc, data FROM guestbook ";
    if($count > 0){
      $query .= "ORDER BY data DESC LIMIT $count";
    }
    else{
      $query .= "ORDER BY data DESC";
    }
    if(($result = $this->dbo->query($query)) && 
       ($rows = $result->fetchAll(PDO::FETCH_ASSOC))){
       return $rows;
    }
    else{
      return array();
    }
  }
  function showMain()
  {
    $gbdata = $this->getGuestbookItems(3);
    include 'tmpl/main.tpl.php';
  }
  function showGuestbook()
  {
    include 'tmpl/form.tpl.php';
  }
}

?>