<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $key = 'tajnyklucz';
  
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zapytań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  
  function mycrypt($data, $key, $decrypt = false)
  {
    $td = mcrypt_module_open('tripledes', '', 'ecb', '');
    $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size($td), MCRYPT_RAND);
    mcrypt_generic_init($td, $key, $iv);
    if($decrypt){
      $output = mdecrypt_generic($td,  base64_decode($data));
    }
    else{
      $output = base64_encode(mcrypt_generic($td, $data));
    }
    mcrypt_generic_deinit($td);
    mcrypt_module_close($td);
    return $output;
  }
  
  function setMessage($msg)
  {
    setcookie('message', $msg);
  }
  function getMessage()
  {
    if(isset($_COOKIE['message'])){
      $message = $_COOKIE['message'];
      setcookie('message', '');
      return $message;
    }
    return false;
  }
  
  function checkUserAndPass($user, $pass)
  {
    if(!$this->dbo){
      return SERVER_ERROR;
    }
    
    $user = $this->dbo->quote($user);
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Id, Nazwa, Haslo FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->rowCount() == 1){
      $row = $result->fetch();
      //if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
      //hasła niekodowane dla łatwiejszej manipulacji danymi w bazie
      if($row && $row['Haslo'] == $pass){
        //Hasło jest prawidłowe
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        return ACTION_FAILED;
      }
    }
    else{
      return ACTION_FAILED;
    }
  }
  
  function login()
  {
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $_POST["user"];
    $pass = $_POST["pass"];
    
    if($this->checkUserAndPass($user, $pass) == ACTION_OK){
      //Dane logowania prawidłowe
      $this->setMessage("Jesteś zalogowany jako $user.");
      setcookie('user', $this->mycrypt($user, $this->key, false));
      setcookie('pass', $this->mycrypt($pass, $this->key, false));
    }
    else{
      $this->setMessage("Błąd logowania.");
    }
  }
  
  function logout()
  {
    if(isset($_COOKIE['user']) && isset($_COOKIE['pass'])){
      $this->setMessage('Wylogowanie prawidłowe.');
    }
    else{
      $this->setMessage('Najpierw się zaloguj.');
    }
    setcookie('user', '');
    setcookie('pass', '');
  }
    
  function loginCheck()
  {
    if(isset($_COOKIE['user']) && isset($_COOKIE['pass'])){
      $user = trim($this->mycrypt($_COOKIE['user'], $this->key, true), "\0");
      $pass = trim($this->mycrypt($_COOKIE['pass'], $this->key, true), "\0");
      if($this->checkUserAndPass($user, $pass) == ACTION_OK){
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return false;
    }
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    $zalogowany = $this->loginCheck();
    include 'tmpl/main.tpl.php';
  }
}

?>