<?php
/*
 * Szkolenie: Bezpieczeństwo aplikacji internetowych
 * Plik składowy przykładowego projektu
 * Autor: Marcin Lis, http://marcinlis.com
 * Uwaga: Do wszystkich projektów w celach demonstracyjnych zostały wprowdzone błędy.
 * Tych przykładów nigdy nie należy używać w praktyce.
 */
 
class Site
{
  private $dbo = null;
  private $maxBadLoginCount = 3;
  function initDB($host, $user, $pass, $db)
  {
    try{
      $this->dbo = new PDO("mysql:dbname=$db;host=$host;charset=utf8", $user, $pass);
      //Wyłącznie emulacji zaptyań parametryzowanych
      //$this->dbo->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    }
    catch(PDOException $e){
      $msg = "Brak połączenia z bazą danych: ";
      $msg .= $e->getMessage();
      throw new Exception($msg);
    }
  }
  function setMessage($msg)
  {
    $_SESSION['message'] = $msg;
  }
  function getMessage()
  {
    if(isset($_SESSION['message'])){
      $message = $_SESSION['message'];
      unset($_SESSION['message']);
      return $message;
    }
    return false;
  }
  function login()
  {
    unset($_SESSION['zalogowany']);
    
    if(!$this->dbo){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie czy zostały przekazane parametry.
    if(!isset($_POST["user"]) || !isset($_POST["pass"])){
      $this->setMessage('Nieprawidłowe dane.');
      return ACTION_FAILED;
    }
    
    $user = $this->dbo->quote($_POST["user"]);
    $pass = $_POST["pass"];
    
    //Wykonanie zapytania sprawdzającego poprawność danych.
    $query = "SELECT Id, Nazwa, Haslo FROM Users WHERE Nazwa=$user";

    if(!$result = $this->dbo->query($query)){
      $this->setMessage('Błąd serwera. Zalogowanie nie jest możliwe.');
      return SERVER_ERROR;
    }
    
    //Sprawdzenie wyników zapytania.
    if($result->rowCount() == 1){
      $row = $result->fetch();
      //if($row && $row['Haslo'] == crypt($pass, $row['Haslo'])){
      //hasła niekodowane dla łatwiejszej manipulacji danymi w bazie
      if($row && $row['Haslo'] == $pass){
        //Hasło jest prawidłowe
        $this->setMessage("Jesteś zalogowany jako {$row['Nazwa']}.");
        $_SESSION['zalogowany'] = $row;
        return ACTION_OK;
      }
      else{
        //Hasło jest nieprawidłowe
        $this->setMessage('Nieprawidłowa nazwa lub hasło.'.$blokStr);
        return ACTION_FAILED;
      }
    }
    else{
      $this->setMessage('Nieprawidłowa nazwa lub hasło.');
      return ACTION_FAILED;
    }
  }
  
  function logout()
  {
    unset($_SESSION['zalogowany']);
  }
  
  function numberToMonth(&$arr, $field)
  {
    foreach($arr as &$v){
      switch($v[$field]){
        case '1'  : $v[$field] = 'styczeń';break;
        case '2'  : $v[$field] = 'luty';break;
        case '3'  : $v[$field] = 'marzec';break;
        case '4'  : $v[$field] = 'kwiecień';break;
        case '5'  : $v[$field] = 'maj';break;
        case '6'  : $v[$field] = 'czerwiec';break;
        case '7'  : $v[$field] = 'lipiec';break;
        case '8'  : $v[$field] = 'sierpień';break;
        case '9'  : $v[$field] = 'wrzesień';break;
        case '10' : $v[$field] = 'październik';break;
        case '11' : $v[$field] = 'listopad';break;
        case '12' : $v[$field] = 'grudzień';break;
      }
    }
  }
  
  function showSalary()
  {
    if(!isset($_SESSION['zalogowany'])){
      $this->setMessage('Najpierw musisz się zalogować.');
      return ACTION_FAILED;
    }
    
    if(!isset($_REQUEST['userid'])){
      $this->setMessage('Nieprawidłowe wywołanie.');
      return ACTION_FAILED;
    }
    
    $reqUserId = intval($_REQUEST['userid']);
    $userid = intval($_SESSION['zalogowany']['Id']);
    
    if($reqUserId != $userid){
      $this->setMessage('Brak autoryzacji.');
      return ACTION_FAILED;
    }
    
    $query = "SELECT rok, miesiac, suma, data_wyplaty "
           . "FROM wynagrodzenia WHERE " 
           . "pracownik_id = $userid ORDER BY data_wyplaty LIMIT 12";

    if(!($result = $this->dbo->query($query)) || !($dane  = $result->fetchAll())){
      $dane = array();
    }
    
    $this->numberToMonth($dane, 'miesiac');
    
    $message = $this->getMessage();
    $user = $_SESSION['zalogowany']['Nazwa'];
    
    include 'tmpl/salary.tpl.php';
    return ACTION_OK;
  }
  
  function showMain()
  {
    $message = $this->getMessage();
    if(isset($_SESSION['zalogowany'])){
      $user = $_SESSION['zalogowany']['Nazwa'];
      $userid = $_SESSION['zalogowany']['Id'];
    }
    include 'tmpl/main.tpl.php';
  }
}

?>