<?php
class AccessController extends CController
{
	public function filters()
	{
		return array(
			'accessControl',
		);
	}

	public function accessRules()
	{
		return array(
			array(
				'deny',
				'expression' => 'strpos($_SERVER[\'HTTP_USER_AGENT\'], \'MSIE\') !== FALSE',
				'message' => "You're using the wrong browser, sorry.",
			),
			array(
				'allow',
				'actions' => array('authOnly'),
				'users' => array('@'),
			),
			array(
				'allow',
				'actions' => array('ip'),
				'ips' => array('127.0.0.1'),
			),
			array(
				'allow',
				'actions' => array('user'),
				'users' => array('admin'),
			),
			array('deny'),
		);
	}


	public function actionAuthOnly()
	{
		echo "Wyglda na to, e nie masz uprawnie, aby mnie uruchomi.";
	}

	public function actionIp()
	{
		echo "Twoje IP jest na naszej licie. Szczciarz!";
	}

	public function actionUser()
	{
		echo "Jeste waciwym czowiekiem. Witaj!";
	}
}
