<?php
// Pominite zostay wszystkie standardowe metody rekordu aktywnego, dziki czemu moemy si skupi na dodanym kodzie
// Uyj Gii do wygenerowania modelu Post, a nastpnie dodaj ponisze metody

class Post extends CActiveRecord {
    // niestandardowa metoda dodawania komentarza
    // do biecego posta
    function addComment(Comment $comment){
        $comment->post_id = $this->id;

        // tworzenie instancji klasy zdarzenia
        $event = new NewCommentEvent($this);
        $event->post = $this;
        $event->comment = $comment;

        // wyzwalanie zdarzenia
        $this->onNewComment($event);
        return $event->isValid;
    }

    // definiowanie zdarzenia onNewComment
    public function onNewComment($event) {
        // Zdarzenie jest faktycznie wyzwalane w tym miejscu. Dziki temu moemy uy
        // metody onNewComment zamiast metody raiseEvent.
        $this->raiseEvent('onNewComment', $event);
    }
}
