﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI;
using Windows.UI.Text;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The User Control item template is documented at http://go.microsoft.com/fwlink/?LinkId=234236

namespace MojeSpotkania
{
    public sealed partial class TextBoxPlaceholder : UserControl
    {
        public TextBoxPlaceholder()
        {
            this.InitializeComponent();

            TxtBox = new TextBox();
            TxtBox.GotFocus += txtBox_GotFocus;
            TxtBox.LostFocus += txtBox_LostFocus;
            mainGrid.Children.Add(TxtBox);
        }

        private string _PlaceholderText;

        public string PlaceholderText {
            get { return _PlaceholderText; } 
            set 
            {
                _PlaceholderText = value;
                if (string.IsNullOrEmpty(TxtBox.Text))
                {
                    if (PlaceholderText != null)
                        TxtBox.Text = _PlaceholderText;
                    TxtBox.Foreground = new SolidColorBrush(Colors.SkyBlue);
                }

            } 
        }

        public TextBox TxtBox { get; set; }

        public string Text
        {
            get { return TxtBox.Text; }
            set 
            { 
                TxtBox.Text = value; 
                
                if(value == _PlaceholderText)
                    TxtBox.Foreground = new SolidColorBrush(Colors.SkyBlue); 
                else
                    TxtBox.Foreground = new SolidColorBrush(Colors.White); 
            }
        }

        /// <summary>
        /// Definicja właściwości pola tekstowego
        /// </summary>

        private double _MyFontSize;
        public double MyFontSize
        {
            get { return _MyFontSize; }
            set
            {                
                _MyFontSize = value;
                TxtBox.FontSize = value;
            }
        }

        private FontFamily _MyFontFamily;
        public FontFamily MyFontFamily
        {
            get { return _MyFontFamily; }
            set 
            {
                _MyFontFamily = value;
                TxtBox.FontFamily = value; 
            }
        }

        private TextWrapping _MyTextWrapping;
        public TextWrapping MyTextWrapping
        {
            get { return _MyTextWrapping; }
            set
            {
                _MyTextWrapping = value;
                TxtBox.TextWrapping = value;
            }
        }

        private Brush _MyBorderBrush;
        public Brush MyBorderBrush
        {
            get { return _MyBorderBrush; }
            set
            {
                _MyBorderBrush = value;
                TxtBox.BorderBrush = value;
            }
        }

        private Brush _MyForeground;
        public Brush MyForeground
        {
            get { return _MyForeground; }
            set
            {
                _MyForeground = value;
                TxtBox.Foreground = value;
            }
        }

        private Brush _MyBackground;
        public Brush MyBackground
        {
            get { return _MyBackground; }
            set
            {
                _MyBackground = value;
                TxtBox.Background = value;
            }
        }



        /// <summary>
        /// Event wywoływany przy usunięciu kursowa z pola tekstowego
        /// Pojawia się tekst placeholder
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void txtBox_LostFocus(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(TxtBox.Text))
            {
                if(PlaceholderText != null)
                    TxtBox.Text = _PlaceholderText;
                TxtBox.Foreground = new SolidColorBrush(Colors.SkyBlue);
            }
        }

        /// <summary>
        /// Event wywoływany przy zaznaczeniu pola tekstowego
        /// Znika tekst placeholder
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void txtBox_GotFocus(object sender, RoutedEventArgs e)
        {
            if (TxtBox.Text.Equals(PlaceholderText, StringComparison.OrdinalIgnoreCase))
            {
                TxtBox.Text = string.Empty;
                TxtBox.Foreground = new SolidColorBrush(Colors.White);
            }
        }
    }
}