﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.ApplicationModel.Background;

namespace MojeSpotkania
{
    public sealed class ZadanieWTle : IBackgroundTask
    {
        public void Run(IBackgroundTaskInstance taskInstance)
        {
            DobierzSpotkania();
        }

        public ZadanieWTle() 
        { }

        async public void Rozpocznij()
        {
            await BackgroundExecutionManager.RequestAccessAsync();

            TimeTrigger wyzwalaczCzasowy = new TimeTrigger(15, false);
            string punktWejscia = "MojeSpotkania.ZadanieWTle";
            string nazwaZadania = "stronyKafla";            
            var zarejestrowaneZadanie = RejestracjaZadaniaWTle(punktWejscia, nazwaZadania, wyzwalaczCzasowy);            
            zarejestrowaneZadanie.Completed += zarejestrowaneZadanie_Completed;
            zarejestrowaneZadanie.Progress += zarejestrowaneZadanie_Progress;
        }

        void zarejestrowaneZadanie_Progress(BackgroundTaskRegistration sender, BackgroundTaskProgressEventArgs args)
        {
            //
        }

        void zarejestrowaneZadanie_Completed(BackgroundTaskRegistration sender, BackgroundTaskCompletedEventArgs args)
        {
            //
        }


        private static BackgroundTaskRegistration RejestracjaZadaniaWTle(string punktWejsciaZadania, string nazwaZadania, IBackgroundTrigger wyzwalacz)
        {
            foreach (var zadanie in BackgroundTaskRegistration.AllTasks)
                if (zadanie.Value.Name == nazwaZadania)
                    return (BackgroundTaskRegistration)(zadanie.Value);
            var tworca = new BackgroundTaskBuilder();
            tworca.Name = nazwaZadania;
            tworca.TaskEntryPoint = punktWejsciaZadania;
            tworca.SetTrigger(wyzwalacz);
            BackgroundTaskRegistration zarejestrowaneZadanie = tworca.Register();
            return zarejestrowaneZadanie;
        }

        async private void DobierzSpotkania()
        {
            Powiadomienia powiadomienia = new Powiadomienia();
            int i =0;
            List<Spotkanie> listaPosortowanaDatami = new List<Spotkanie>();
            List<Spotkanie> spotkania = await OperacjeBazy.PobierzListeSpotkań();
            while (spotkania.Count > 0 || i < 5)
            {
                Spotkanie najblizsze = znajdzNajblizsze(spotkania);
                powiadomienia.DodajStroneKafelkaAplikacji(najblizsze.Nazwa, najblizsze.Notatka, najblizsze.ID.ToString(),new DateTime(2113,2,1,15,0,0),true);
                spotkania.Remove(najblizsze);
                i++;
            }
        }

        private Spotkanie znajdzNajblizsze(List<Spotkanie> spotkania)
        {
            Spotkanie najblizsze = spotkania[0];
            
            foreach (Spotkanie s in spotkania)
            {
                if (s.Poczatek < najblizsze.Poczatek)
                {
                    najblizsze = s;
                }
            }
            
            return najblizsze;
        }

        private void WyrejestrujZadanieWTle(string nazwaZadania)
        {
            foreach (var zadanie in BackgroundTaskRegistration.AllTasks)
                if (zadanie.Value.Name == nazwaZadania)
                    zadanie.Value.Unregister(true);
        }

    }
}
