﻿using NotificationsExtensions.TileContent;
using NotificationsExtensions.ToastContent;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.ApplicationModel.Background;
using Windows.Foundation;
using Windows.Storage;
using Windows.UI.Notifications;
using Windows.UI.Popups;

namespace MojeSpotkania
{
    public class Roaming
    {
        ApplicationDataContainer ustawieniaRoaming = ApplicationData.Current.RoamingSettings;

        public Roaming()
        {
        }

        /// <summary>
        /// zapisuje ostatnio czytane źródło
        /// </summary>
        /// <param name="ostatnioCzytanyObiektRSS">ostatnio czytane źródło</param>
        public void ZapiszOstatnioCzytanyObiektKanaluRSS(string ostatnioCzytanyObiektRSS)
        {
            ApplicationDataCompositeValue kontenerRSS = new ApplicationDataCompositeValue();
            kontenerRSS["LastReadedFeed"] = ostatnioCzytanyObiektRSS;
            ustawieniaRoaming.Values["HighPriority"] = kontenerRSS;
        }

        /// <summary>
        /// Metoda pozwalająca na dodanie obiektu dowolnego z podstawowych typów do przechowywania w roamingu.
        /// </summary>
        /// <param name="nazwa"></param>
        /// <param name="wartosc"></param>
        public void DodajDowolnyObiektDoRoamingu(string nazwa, object wartosc)
        {
            ApplicationDataContainer kontener;
            if (!ustawieniaRoaming.Containers.ContainsKey("dane"))
                kontener = ustawieniaRoaming.CreateContainer("dane", ApplicationDataCreateDisposition.Always);
            ustawieniaRoaming.Containers["dane"].Values[nazwa] = wartosc;
        }

        public async Task <object> ZaładujDowolnyObiektZRoamingu(string nazwa)
        {
            object wartosc;

            if (!ustawieniaRoaming.Containers.ContainsKey("dane") || !ustawieniaRoaming.Containers["dane"].Values.ContainsKey(nazwa))
            { 
                string trescKomunikatu = "Żądany obiekt lub dana nie istnieje";
                MessageDialog komunikat = new MessageDialog(trescKomunikatu);
                await komunikat.ShowAsync();
                return null;
            }
            wartosc = ustawieniaRoaming.Containers["dane"].Values[nazwa];
            return wartosc;
        }

        /// <summary>
        /// Metoda zczytująca ostatnio czytany tytuł
        /// </summary>
        /// <returns>Ostatnio czytane źródło lub null jeśli takowego nie ma</returns>
        public string ZaładujOstatnioCzytanyObiektKanaluRSS()
        {

            ApplicationDataCompositeValue OstatnioCzytanyObiektRSS = (ApplicationDataCompositeValue)ustawieniaRoaming.Values["HighPriority"];

            if (OstatnioCzytanyObiektRSS == null)
            {
                return null;
            }
            else
            {
                return (string)OstatnioCzytanyObiektRSS["LastReadedFeed"];
            }
        }

    }
}




