﻿using SQLite;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Windows.UI.Xaml.Media.Imaging;

namespace MojeSpotkania
{
    public static class OperacjeBazy
    {
        public static async Task<List<Spotkanie>> PobierzListeSpotkan()
        {
            List<Spotkanie> listaSpotkan;

            SQLiteAsyncConnection conn = new SQLiteAsyncConnection("BazaSpotkan.db");
            await conn.CreateTableAsync<Spotkanie>();
            var zapytanieSpotkanie = conn.Table<Spotkanie>();
            listaSpotkan = await zapytanieSpotkanie.ToListAsync();

            return listaSpotkan;
        }

        /// <summary>
        /// Metoda znajdywania frazy podanej podczas wyszukiwania w bazie danych
        /// </summary>
        /// <param name="parametr">Fraza pobrana z wyszukiwania</param>
        /// <returns>Lista spotkań zawierających wyszukiwaną frazę</returns>
        public static async Task<List<Spotkanie>> ZnajdzSpotkanie(string parametr)
        {
            List<Spotkanie> listaSpotkan;

            SQLiteAsyncConnection conn = new SQLiteAsyncConnection("BazaSpotkan.db");
            await conn.CreateTableAsync<Spotkanie>();
            var wyszukaneElementy = conn.Table<Spotkanie>().Where(x => x.Nazwa.Contains(parametr) || x.Notatka.Contains(parametr));

            listaSpotkan = await wyszukaneElementy.ToListAsync();
           
            return listaSpotkan;
        }

        /// <summary>
        /// Metoda zwracająca wybrane spotkanie
        /// </summary>
        /// <param name="SpotkanieID">Parametr ID klikniętego spotkanie</param>
        /// <returns>Spotkanie o wybranym ID</returns>
        public static async Task<Spotkanie> PobierzSpotkanie(int SpotkanieID)
        {
            SQLiteAsyncConnection conn = new SQLiteAsyncConnection("BazaSpotkan.db");
            List<Spotkanie> listaSpotkan;
            await conn.CreateTableAsync<Spotkanie>();
            var zapytanieSpoktanie = conn.Table<Spotkanie>().Where(x => x.ID == SpotkanieID);
            listaSpotkan = await zapytanieSpoktanie.ToListAsync();

            Spotkanie spotkanie = listaSpotkan.ElementAt(0);

            return spotkanie;
        }


        /// <summary>
        /// Metoda dodająca spotanie do bazy danych
        /// </summary>
        /// <param name="spotkanie">Obiekt reprezentujący spotkanie, które ma byćdodane do bzy danych</param>
        public static void DodajSpotkanie(Spotkanie spotkanie)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.CreateTable<Spotkanie>();

                db.RunInTransaction(() =>
                {
                    db.Insert(spotkanie);
                });
            }
        }

        public static void EdytujSpotkanie(Spotkanie spotkanie)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.CreateTable<Spotkanie>();

                db.RunInTransaction(() =>
                {
                    db.Update(spotkanie);
                });
            }
        }

        public static void UsunSpotkanie(int elementID)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.RunInTransaction(() =>
                {
                    db.Delete<Spotkanie>(elementID);
                });
            }
        }

        public static void DodajPunktAgendy(PunktAgendy punktAgendy)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.CreateTable<PunktAgendy>();

                db.RunInTransaction(() =>
                {
                    db.Insert(punktAgendy);
                });
            }
        }

        public static void EdytujPunktAgendy(PunktAgendy punktAgendy)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.CreateTable<PunktAgendy>();

                db.RunInTransaction(() =>
                {
                    db.Update(punktAgendy);
                });
            }
        }

        public static void UsunPunktAgendy(int elementID)
        {
            var dbPath = Path.Combine(Windows.Storage.ApplicationData.Current.LocalFolder.Path, "BazaSpotkan.db");
            using (var db = new SQLite.SQLiteConnection(dbPath))
            {
                db.RunInTransaction(() =>
                {
                    db.Delete<PunktAgendy>(elementID);
                });
            }
        }

        public static async Task<List<PunktAgendy>> PobierzPunktyAgendy(int SpotkanieID)
        {
            SQLiteAsyncConnection conn = new SQLiteAsyncConnection("BazaSpotkan.db");
            List<PunktAgendy> ListaPunktow;
            await conn.CreateTableAsync<PunktAgendy>();
            var zapytaniePunkt = conn.Table<PunktAgendy>().Where(x => x.IDSpotkania == SpotkanieID);
            ListaPunktow = await zapytaniePunkt.ToListAsync();

            return ListaPunktow;
        }


        public static async Task<int> OstatnieID()
        {
            SQLiteAsyncConnection conn = new SQLiteAsyncConnection("BazaSpotkan.db");

            await conn.CreateTableAsync<Spotkanie>();
            int ostatnieID =  conn.Table<Spotkanie>().OrderByDescending(u => u.ID).FirstOrDefaultAsync().Id;
 

            return ostatnieID;
        }


    }
}