﻿package {
	
	import flash.display.MovieClip;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.events.Event;
	import flash.geom.Matrix;
	
	public class Main extends MovieClip {
		
		private const DURATION:uint = 5;
		private var frames:uint  = 0;
		private var monkeys:Array = [];
		
		public function Main() {
			
			addEventListener(Event.ENTER_FRAME, enterFrame);
			
			var t:Timer = new Timer(DURATION * 1000, 1);
			t.addEventListener(TimerEvent.TIMER_COMPLETE, timerComplete);
			t.start();
									
			var matrix:Matrix = new Matrix();
			for(var i:uint = 0; i < 10; i++)
			{
				var monkey:MovieClip = new Monkey();
				monkey.x = Math.random() * stage.stageWidth;
				monkey.y = Math.random() * stage.stageHeight;
				monkey.rotation = Math.random() * 360;
				monkey.cacheAsBitmap = true;
				monkey.cacheAsBitmapMatrix = matrix;
				
				monkeys.push(monkey);
				
				addChild(monkey);
			}
			
			msgField.visible = false;
		}
		
		private function timerComplete(e:TimerEvent):void {
			removeEventListener(Event.ENTER_FRAME, enterFrame);
			var fps:uint = frames / DURATION;
			msgField.visible = true;
			msgField.text = fps + " fps";
			addChild(msgField);
		}
		
		private function enterFrame(e:Event):void {
			frames++;
			for(var i:uint = 0; i < monkeys.length; i++)
			{
				var monkey:MovieClip = monkeys[i];
				monkey.rotation++;
			}
		}
	}
}
