﻿package {
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.net.URLRequest;
	
	public class Main extends MovieClip {
		
		private var sound:Sound;
		private var channel:SoundChannel;
		private var pausePosition:int;
		
		public function Main() {
			pausePosition = 0;
			
			playBtn.addEventListener(MouseEvent.MOUSE_UP, playSound);
			pauseBtn.addEventListener(MouseEvent.MOUSE_UP, pauseSound);
			pauseBtn.visible = false;
		}
		
		private function playSound(e:MouseEvent):void {
			if(sound == null)
			{
				var url:URLRequest = new URLRequest("music.mp3");
				sound = new Sound(url);
			}
			
			channel = sound.play(pausePosition);
			channel.addEventListener(Event.SOUND_COMPLETE, complete);
			toggleBtn();
		}
		
		private function pauseSound(e:MouseEvent):void {
			pausePosition = channel.position;
			channel.stop();
			channel.removeEventListener(Event.SOUND_COMPLETE, complete);
			toggleBtn();
		}
		
		private function complete(e:Event):void {
			channel.removeEventListener(Event.SOUND_COMPLETE, complete);
			pausePosition = 0;
			toggleBtn();
		}
		
		private function toggleBtn():void {
			playBtn.visible = !playBtn.visible;
			pauseBtn.visible = !pauseBtn.visible;
		}
	}
}
