﻿package {
	
	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.events.SampleDataEvent;
	import flash.media.Microphone;
	import flash.utils.ByteArray;
	
	public class Main extends MovieClip {
		
		private var mic      :Microphone;
		private var soundData:ByteArray;
		
		public function Main() {
			micStatus.gotoAndStop(1);
			recordBtn.visible = true;
			stopBtn.visible = false;
			recordBtn.addEventListener(MouseEvent.MOUSE_UP, pressedRecordBtn);
			stopBtn.addEventListener(MouseEvent.MOUSE_UP, pressedStopBtn);
			
			mic = Microphone.getMicrophone();
			if(!Microphone.isSupported || mic == null)
			{
				recordBtn.visible = false;
			}
		}
		
		private function pressedRecordBtn(e:MouseEvent):void {
			startRecording();
		}
		
		private function pressedStopBtn(e:MouseEvent):void {
			stopRecording();
		}
		
		private function startRecording():void {
			micStatus.gotoAndStop(2);
			recordBtn.visible = false;
			stopBtn.visible = true;
			
			soundData = new ByteArray();
			mic.gain = 100;
			mic.rate = 44;
			mic.addEventListener(SampleDataEvent.SAMPLE_DATA, sampleData);
		}
		
		private function sampleData(e:SampleDataEvent):void {
			while(e.data.bytesAvailable)
			{
				var sample:Number = e.data.readFloat();
				soundData.writeFloat(sample);
			}
			
			if(soundData.length > 2097152)
			{
				stopRecording();
			}
		}
		
		private function stopRecording():void {
			micStatus.gotoAndStop(1);
			stopBtn.visible = false;
			mic.removeEventListener(SampleDataEvent.SAMPLE_DATA, sampleData);
		}
	}
}
