﻿package {
	
	import flash.display.MovieClip;
	import flash.display.BitmapData;
	import flash.filesystem.File;
	import flash.filesystem.FileStream;
	import flash.filesystem.FileMode;
	import flash.geom.Rectangle;
	import flash.media.StageWebView;
	import flash.utils.ByteArray;
	import com.adobe.images.PNGEncoder;
	
	public class Main extends MovieClip {
		
		private var webView:StageWebView;
		
		public function Main() {
			createHtml();
			loadHtml();
		}
		
		private function createHtml():void {
			var cssString:String = "body" +
				"{ padding:0px; border:0px; margin:0px; " +
				"background-color:#cdc0af }";
			
			var htmlString:String = "<!DOCTYPE HTML>" +					
				"<html>" +
					"<head>" +
						"<link rel='stylesheet' type='text/css' " +
						"href='styles.css' />" +
						"<meta name='viewport' " + 
						"content='width=device-width; " +
						"height=device-height; initial-scale=1.0; " +
						"maximum-scale=1.0; user-scalable=0;' />" +
					"</head>" +
					"<body>" +
						"<img src='image.png' />" +
					"</body>" +
				"</html>";

			var image:BitmapData = new Image();
				
			writeFile(htmlString, "index.html");
			writeFile(cssString, "styles.css");
			writePng(image, "image.png");
		}
		
		private function writeFile(text:String, name:String):void {
			var file:File = File.documentsDirectory.resolvePath(name);
			var stream:FileStream = new FileStream();
			stream.open(file, FileMode.WRITE);
			stream.writeUTFBytes(text);
			stream.close();
		}
		
		private function writePng(bd:BitmapData, name:String):void {
			var pngBytes:ByteArray = PNGEncoder.encode(bd);
			
			var file:File = File.documentsDirectory.resolvePath(name);
			var stream:FileStream = new FileStream();
			stream.open(file, FileMode.WRITE);
			stream.writeBytes(pngBytes);
			stream.close();
		}
		
		private function loadHtml():void {
			var url:String = File.documentsDirectory.resolvePath("index.html").nativePath;
			
			webView = new StageWebView();
			webView.stage = stage;
			webView.viewPort = new Rectangle(0, 0, stage.stageWidth, stage.stageHeight);
			webView.loadURL(url);
		}
	}
}
