﻿package {
	
	import flash.display.MovieClip;
	import flash.events.GeolocationEvent;
	import flash.sensors.Geolocation;
	
	public class Main extends MovieClip {
		
		private const CONVERSION_FACTOR:Number = 2.237;
		private var geo:Geolocation;
		
		public function Main() {
			if(Geolocation.isSupported)
			{
				geo = new Geolocation();
				geo.setRequestedUpdateInterval(50);
				geo.addEventListener(GeolocationEvent.UPDATE, geoUpdated);
			}
		}
		
		private function geoUpdated(e:GeolocationEvent):void {
			var metersPerSecond:Number = e.speed;
			var milesPerHour:uint = getMilesPerHour(metersPerSecond);
			speed1Field.text = String(metersPerSecond);
			speed2Field.text = String(milesPerHour);
			
			var heading:Number = e.heading;
			compass.rotation = 360 - heading;
			headingField.text = String(heading);
		}
		
		private function getMilesPerHour(metersPerSecond:Number):uint {
			return metersPerSecond * CONVERSION_FACTOR;
		}
	}
}
