from llama_index.core.schema import TextNode, NodeWithScore
from llama_index.core import get_response_synthesizer

nodes = [ 
    TextNode(text=
        "Zegar na rynku został zbudowany w 1895 roku."
    ), 
    TextNode(text=
        "Turkusowa papuga żyje w Amazonii."
    ), 
    TextNode(text=
        "Rzadki gatunek orchidei kwitnie o północy."
    ), 
] 

node_with_score_list = [NodeWithScore(node=node) for node in nodes] 
synth = get_response_synthesizer( 
    response_mode="refine", 
    use_async=False, 
    streaming=False, 
) 

response = synth.synthesize( 
    "Kiedy zbudowano zegar?", 
    nodes=node_with_score_list 
) 
print(response) 