import streamlit as st
import os
from session_functions import save_session
from logging_functions import log_action
from global_settings import STORAGE_PATH
from document_uploader import ingest_documents
from training_material_builder import generate_slides
from index_builder import build_indexes
from quiz_builder import build_quiz
import pandas as pd

def user_onboarding():
    user_name = st.text_input('Jak masz na imię?')
    if not user_name: return

    st.session_state['user_name'] = user_name
    st.write(f"Witaj {user_name}. Miło Cię poznać!")
    
    study_subject = st.text_input('Czego chciałbyś się nauczyć?')
    if not study_subject: return

    st.session_state['study_subject'] = study_subject
    st.write(f"Dobrze {user_name}, skupmy się na {study_subject}.")
    
    study_goal = st.text_input(
        'Sprecyzuj swój cel swoich badań lub pozostaw to pole puste:', 
        key='Study Goal'
    )
    st.session_state['study_goal'] = study_goal or "Bez określonego celu"
    
    if study_goal:
        st.write("Czy chcesz załadować swoje materiały do nauki?")
        uploaded_files = st.file_uploader("Wybierz pliki", accept_multiple_files=True)
        finish_upload = st.button('KONIEC WCZYTYWANIA')

        if finish_upload and uploaded_files:
            saved_file_names = []
            for uploaded_file in uploaded_files:
                file_path = os.path.join(STORAGE_PATH, uploaded_file.name)
                with open(file_path, "wb") as f:
                    f.write(uploaded_file.getbuffer())
                saved_file_names.append(uploaded_file.name)
                st.write(f"Załadowałeś {uploaded_file.name}")

            st.session_state['uploaded_files'] = saved_file_names
            st.session_state['finish_upload'] = True
            st.info('Wczytywanie plików...')
    
    if 'finish_upload' in st.session_state or 'difficulty_level' in st.session_state:
        st.write('Jaka jest Twój aktualny poziom wiedzy na ten temat?')
        difficulty_level = st.radio(
            'Aktualny poziom:', 
            ['Począkujący', 'Średniozaawansowany', 'Zaawansowany', 'Określ za pomocą testu'],
        )
        st.session_state['difficulty_level'] = difficulty_level
        proceed_button = st.button('Dalej')
        st.write(f'Twój wybór: {difficulty_level}')
        
        if proceed_button:
            save_session(st.session_state)
            if difficulty_level == 'Rozwiąż test, by określić swój poziom':
                st.info('Przechodzenie do quizu. Wczytywanie materiałów dydaktycznych...')
                nodes = ingest_documents()
                st.info('Materiały wczytane. Przygotowywanie indeksów...')
                keyword_index , vector_index = build_indexes (nodes)
                st.info('Zakończono ideksowanie. Generowanie quizu...')
                quiz = build_quiz(study_subject)
                st.session_state['show_quiz'] = True
                st.rerun()
                st.info('Zakończono ideksowanie. Generowanie slajdów...')
                generate_slides(study_subject)
            else:
                log_action(
                    f"{user_name} chce zgłębić wiedzę na temat {study_subject}, "
                    f"i osiągnąć taki cel: '{study_goal}'. "
                    f"Użytkownik wczytał {len(uploaded_files)} pliki i rozwiązał test sprawdzenia wiedzy "
                    f"Aktualny poziom użytkownika to: {difficulty_level}",
                    action_type="ONBOARDING"
                )
                st.info(f'Przygotowywanie kursu na poziomie {difficulty_level}')
                st.info('Wczytywanie materiałów dydatktycznych...')
                nodes = ingest_documents()
                st.info('Materiały wczytane. Przygotowywanie indeksów...')
                keyword_index , vector_index = build_indexes (nodes)
                st.info('Zakończono ideksowanie. Generowanie slajdów...')
                generate_slides(study_subject)
