from llama_index.core import VectorStoreIndex, SimpleDirectoryReader
from llama_index.core.chat_engine import CondenseQuestionChatEngine
from llama_index.core.llms import ChatMessage

documents = SimpleDirectoryReader("pliki").load_data()
index = VectorStoreIndex.from_documents(documents)
query_engine=index.as_query_engine()
chat_history = [
    ChatMessage(
        role="user",
        content="Łuk Konstantyna to słynna"
        "budowla w Rzymie."
    ),
    ChatMessage(
        role="user",
        content="Panteon nie powienien "
        "być uważany jako sławna budowla."
    ),
]

chat_engine = CondenseQuestionChatEngine.from_defaults(
    query_engine=query_engine,
    chat_history=chat_history
)
response = chat_engine.chat(
    "Jakie są dwie najsławniejsze budowle w Rzymie?"
)
print(response)
