from llama_index.core import ComposableGraph, SimpleDirectoryReader, TreeIndex, SummaryIndex

documents = SimpleDirectoryReader("pliki").load_data()
index1 = TreeIndex.from_documents([documents[0]])
index2 = TreeIndex.from_documents([documents[1]])
summary1 = "Krótki wstęp do starożytnego Rzymu"
summary2 = "Kilka faktów o psach"

graph = ComposableGraph.from_indices(
    SummaryIndex, [index1, index2], 
    index_summaries=[summary1, summary2]
)
query_engine = graph.as_query_engine()

response = query_engine.query("Co możesz mi powiedzieć?")
print(response)
