from llama_index.core.vector_stores import MetadataFilter, MetadataFilters
from llama_index.core import VectorStoreIndex
from llama_index.core.schema import TextNode
user_departments = {"Alicja": "Bezpieczeństwo IT", "Robert": "Usługi IT"}

nodes = [
    TextNode(
        text=(
            "Incydent to przypadkowe lub złośliwe zdarzenie, które ma potencjał spowodowania niepożądanych skutków dla bezpieczeństwa naszych zasobów IT."),
        metadata={"department": "Bezpieczeństwo IT"},
    ),
    TextNode(
        text=("Incydent to nieoczekiwane przerwanie lub pogorszenie jakości usługi IT."),
        metadata={"department": "Usługi IT"},
    )
]

def show_report(index, user, query):
    user_department = user_departments[user]
    filters = MetadataFilters(
        filters=[
            MetadataFilter(key="department", value=user_department)
        ]
    )
    retriever = index.as_retriever(filters=filters)
    response = retriever.retrieve(query)
    print(f"Odpowiedź dla {user}: {response[0].node.text}")


index = VectorStoreIndex(nodes)
query = "Co oznacza termin incydent?"
show_report(index, "Alicja", query)
show_report(index, "Robert", query)
