from llama_index.core import Document, SummaryIndex
from llama_index.core.node_parser import SimpleNodeParser
from llama_index.readers.wikipedia import WikipediaReader

loader = WikipediaReader()
documents = loader.load_data(pages=["Messi Lionel"])
parser = SimpleNodeParser.from_defaults()
nodes = parser.get_nodes_from_documents(documents)
index = SummaryIndex(nodes)
query_engine = index.as_query_engine()
print("Zapytaj mnie o cokolwiek, co dotyczy Lionela Messi!")

while True:
    question = input("Twoje pytanie: ")
    if question.lower() == "koniec":
        break
    response = query_engine.query(question)
    print(response)
