-- Listing 7.5

CREATE TRIGGER HumanResources.DepartmentChangeAudit
ON HumanResources.Department
AFTER INSERT, UPDATE, DELETE
NOT FOR REPLICATION
AS
BEGIN
  -- Zatrzymaj, jeli nie zmodyfikowano adnego wiersza.
  IF @@ROWCOUNT = 0 RETURN

  -- Wycz komunikaty "rows affected". 
  SET NOCOUNT ON;

  DECLARE @ActionType nvarchar(10), @ActionXml xml;

  -- Pobierz liczb wstawionych wierszy.
  DECLARE @inserted_count int = (
    SELECT COUNT(*)
    FROM inserted
  );

  -- Pobierz liczb usunitych wierszy.
  DECLARE @deleted_count int = (
    SELECT COUNT(*)
    FROM deleted
  );

  -- Ustal typ operacji uruchamiajcej wyzwalacz. 
  SET @ActionType = CASE
    WHEN (@inserted_count > 0) AND (@deleted_count = 0) THEN N'insert'
    WHEN (@inserted_count = 0) AND (@deleted_count > 0) THEN N'delete'
    ELSE N'update'
  END;

  -- Uyj FOR XML AUTO, by pobra zrzuty danych przed modyfikacj i po modyfikacji w formacie XML.
  SELECT @ActionXml = COALESCE
  (
    (
      SELECT *
      FROM deleted
      FOR XML AUTO
    ), N'<deleted/>'
  ) + COALESCE
  (
    (
      SELECT *
      FROM inserted
      FOR XML AUTO
    ), N'<inserted/>'
  );

  -- Wstaw wiersz z informacj o operacji do tabeli.
  INSERT INTO dbo.DmlActionLog
  (
    SchemaName,
    TableName,
    ActionType,
    ActionXml,
    LoginName,
    ApplicationName,
    HostName
  )
  SELECT
    OBJECT_SCHEMA_NAME(@@PROCID, DB_ID()),
    OBJECT_NAME(t.parent_id, DB_ID()),
    @ActionType,
    @ActionXml,
    SUSER_SNAME(),
    APP_NAME(),
    HOST_NAME()
  FROM sys.triggers t
  WHERE t.object_id = @@PROCID;
END;
GO

