-- Listing 7.2

CREATE TRIGGER HumanResources.EmployeeUpdateTrigger
ON HumanResources.Employee
AFTER UPDATE
NOT FOR REPLICATION
AS
BEGIN
  -- Zatrzymaj, jeli nie zmodyfikowano adnego wiersza.
  IF @@ROWCOUNT = 0 RETURN
  -- Wycz komunikaty "rows affected". 
  SET NOCOUNT ON;
  -- Upewnij si, e przynajmniej jeden wiersz zosta zmodyfikowany.
  -- Zaktualizuj ModifiedDate dla wszystkich wierszy. 
  UPDATE HumanResources.Employee
  SET ModifiedDate = GETDATE()
  WHERE EXISTS
  (
    SELECT 1
    FROM inserted i
    WHERE i.BusinessEntityID = HumanResources.Employee.BusinessEntityID
  );
END;
