-- Listing 5.7

-- Ta procedura skadowana wywietla krki na supkach
CREATE PROCEDURE dbo.PokazWieze
AS
BEGIN
-- Kady krek wywietlany jest jako "===3===", gdzie liczba opisuje krek, a szeroko === wskazuje wielko krka. 
-- Te wyraenia nazwane su do wywietlania w odpowiedniej kolejnoci krkw na supkach.
WITH PiecLiczb(Num) -- Rekurencyjne wyraenie nazwane generuje tabel z liczbami 1..5
AS
(
  SELECT 1

  UNION ALL

  SELECT Num + 1
  FROM PiecLiczb
  WHERE Num < 5
),
WiezaA (Krazek) -- Krki wiey A 
AS
(
  SELECT COALESCE(a.Krazek, -1) AS Krazek
  FROM PiecLiczb f
  LEFT JOIN #WiezaA a
  ON f.Num = a.Krazek
),
WiezaB (Krazek) -- Krki wiey B 
AS
(
  SELECT COALESCE(b.Krazek, -1) AS Krazek
  FROM PiecLiczb f
  LEFT JOIN #WiezaB b
  ON f.Num = b.Krazek
),
WiezaC (Krazek) -- Krki wiey C 
AS
(
  SELECT COALESCE(c.Krazek, -1) AS Krazek
  FROM PiecLiczb f
  LEFT JOIN #WiezaC c
  ON f.Num = c.Krazek
)
-- To zapytanie SELECT generuje tekstow reprezentacj wie oraz krkw.
-- FULL OUTER JOIN pozwala umieci wiee obok siebie.
SELECT CASE a.Krazek
    WHEN 5 THEN ' =====5===== '
    WHEN 4 THEN '  ====4==== '
    WHEN 3 THEN '   ===3=== '
    WHEN 2 THEN '    ==2== '
    WHEN 1 THEN '     =1= '
    ELSE        '      | '
END AS Wieza_A,
CASE b.Krazek
    WHEN 5 THEN ' =====5===== '
    WHEN 4 THEN '  ====4==== '
    WHEN 3 THEN '   ===3=== '
    WHEN 2 THEN '    ==2== '
    WHEN 1 THEN '     =1= '
    ELSE        '      | '
END AS Wieza_B,
CASE c.Krazek
    WHEN 5 THEN ' =====5===== '
    WHEN 4 THEN '  ====4==== '
    WHEN 3 THEN '   ===3=== '
    WHEN 2 THEN '    ==2== '
    WHEN 1 THEN '     =1= '
    ELSE        '      | '
END AS Wieza_C
FROM (
    SELECT ROW_NUMBER() OVER(ORDER BY Krazek) AS Num,
    COALESCE(Krazek, -1) AS Krazek
    FROM WiezaA
) a
FULL OUTER JOIN (
    SELECT ROW_NUMBER() OVER(ORDER BY Krazek) AS Num,
    COALESCE(Krazek, -1) AS Krazek
    FROM WiezaB
) b
ON a.Num = b.Num
FULL OUTER JOIN (
    SELECT ROW_NUMBER() OVER(ORDER BY Krazek) AS Num,
    COALESCE(Krazek, -1) AS Krazek
    FROM WiezaC
) c
ON b.Num = c.Num
ORDER BY a.Num;
END;
GO

-- Ta procedura przenosi jeden krek ze wskazanej wiey na inn wskazan wie.
CREATE PROCEDURE dbo.PrzeniesJedenKrazek (@Skad nchar(1),
@Dokad nchar(1))
AS
BEGIN
-- @NajmniejszyKrazek to najmniejszy krek na wskazanej wiey.
DECLARE @NajmniejszyKrazek int = 0;
-- Warunek IF ... ELSE pobiera najmniejszy krek ze wskazanej wiey.
IF @Skad = N'A'
BEGIN
  -- To pobiera najmniejszy krek z wiey A.
  SELECT @NajmniejszyKrazek = MIN(Krazek)
  FROM #WiezaA;
  -- Nastpnie kasuje go z wiey A. 
  DELETE FROM #WiezaA
  WHERE Krazek = @NajmniejszyKrazek;
END
ELSE IF @Skad = N'B'
BEGIN
  -- To pobiera najmniejszy krek z wiey B. 
  SELECT @NajmniejszyKrazek = MIN(Krazek)
  FROM #WiezaB;
  -- Nastpnie kasuje go z wiey B. 
  DELETE FROM #WiezaB
  WHERE Krazek = @NajmniejszyKrazek;
END
ELSE IF @Skad = N'C'
BEGIN
  -- To pobiera najmniejszy krek z wiey C. 
  SELECT @NajmniejszyKrazek = MIN(Krazek)
  FROM #WiezaC;
  -- Nastpnie kasuje go z wiey C. 
  DELETE FROM #WiezaC
  WHERE Krazek = @NajmniejszyKrazek;
END
-- Poka przeniesiony krek.
SELECT N'Przenosz krek (' + CAST(COALESCE(@NajmniejszyKrazek, 0) AS nchar(1)) +
N') z wiey ' + @Skad + N' na wie ' + @Dokad + ':' AS Opis;
-- Wykonaj ruch - wstaw krek z pierwszej wiey do drugiej wiey.
IF @Dokad = N'A'
  INSERT INTO #WiezaA (Krazek) VALUES (@NajmniejszyKrazek);
ELSE IF @Dokad = N'B'
  INSERT INTO #WiezaB (Krazek) VALUES (@NajmniejszyKrazek);
ELSE IF @Dokad = N'C'
  INSERT INTO #WiezaC (Krazek) VALUES (@NajmniejszyKrazek);
  -- Pokazuje wiee.
  EXECUTE dbo.PokazWieze;
END;
GO

-- Ta procedura skadowana przenosi krki rekurencyjnie.
CREATE PROCEDURE dbo.PrzeniesKrazki (@Krazki int,
  @NumRuchu int OUTPUT,
  @Skad nchar(1) = N'A',
  @Dokad nchar(1) = N'C',
  @Pomoc nchar(1) = N'B'
)
AS
BEGIN
  -- Jeli pozostao 0 krkw do przeniesienia, mamy rozwizanie. 
  IF @Krazki = 0
    PRINT N'Gotowe';
  ELSE
  BEGIN
    --Jeli liczba krkw do przeniesienia rwna 1, przenie. 
    IF @Krazki = 1
    BEGIN
    -- Zwiksz licznik ruchw o 1.
    SELECT @NumRuchu += 1;
    -- W kocu przenie jeden krek z jednej wiey na drug.
    EXEC dbo.PrzeniesJedenKrazek @Skad, @Dokad;
    END
    ELSE
    BEGIN
    -- Ustal, ile krkw trzeba przenie na wie pomocnicz.
    DECLARE @n int = @Krazki - 1;

    -- Przenie (@Krazki - 1) krkw na wie pomocnicz.
    EXEC dbo.PrzeniesKrazki @n, @NumRuchu OUTPUT, @Skad, @Pomoc, @Dokad;

    -- Przenie 1 krek z wiey rdowej na docelow. 
    EXEC dbo.PrzeniesKrazki 1, @NumRuchu OUTPUT, @Skad, @Dokad, @Pomoc;

    -- Przenie (@Krazki - 1) krkw z wiey pomocniczej na docelow.
    EXEC dbo.PrzeniesKrazki @n, @NumRuchu OUTPUT, @Pomoc, @Dokad, @Skad;
    END;
  END;
END;
GO

-- Ta procedura skadowana tworzy trzy wie i wypenia wie A 5 krkami. 
CREATE PROCEDURE dbo.WiezeHanoi
AS
BEGIN
  -- SET NOCOUNT ON, by pozby si komunikatw systemowych.
  SET NOCOUNT ON;
  -- Utwrz trzy wiee: A, B i C. 
  CREATE TABLE #WiezaA (Krazek int PRIMARY KEY NOT NULL);
  CREATE TABLE #WiezaB (Krazek int PRIMARY KEY NOT NULL);
  CREATE TABLE #WiezaC (Krazek int PRIMARY KEY NOT NULL);
  -- Umie wszystkie pi krkw w wiey A.
  INSERT INTO #WiezaA (Krazek)
  VALUES (1), (2), (3), (4), (5);
  -- Ustaw numer ruchu na 0.
  DECLARE @NumRuchu int = 0;
  -- Poka stan pocztkowy wie.
  EXECUTE dbo.PokazWieze;
  -- Rozwi amigwk. Zauwa, e nie musisz przekazywa domylnych parametrw. 
  EXECUTE dbo.PrzeniesKrazki 5, @NumRuchu OUTPUT;
  -- Ile ruchw byo potrzebnych?
  PRINT N'Rozwizana w ' + CAST (@NumRuchu AS nvarchar(10)) + N' ruchach.';
  -- Usu tabele tymczasowe - warto zawsze to robi.
  DROP TABLE #WiezaC;
  DROP TABLE #WiezaB;
  DROP TABLE #WiezaA;
  -- SET NOCOUNT OFF przed zakoczeniem.
  SET NOCOUNT OFF;
END;
GO
