-- Listing 5.2

CREATE PROCEDURE Person.GetEmployee_inmem
(
    @BusinessEntityID int = NULL
  , @Email_Address nvarchar(50) OUTPUT
  , @Full_Name nvarchar(100) OUTPUT
)

/*** Nowa skadnia InMemory ***/
WITH NATIVE_COMPILATION, SCHEMABINDING, EXECUTE AS OWNER
AS
/*** Nowa skadnia InMemory ***/
BEGIN ATOMIC WITH
  (TRANSACTION ISOLATION LEVEL = SNAPSHOT,
  LANGUAGE = N'us_english')

/*** Nowa zmienna obsugujca logik ReturnCode ***/
DECLARE @ReturnCode bit = 0;
    -- Pobranie adresw e-mail i nazwisk z tabeli HumanResources.Employee 
    SELECT @Email_Address = ea.EmailAddress,
        @Full_Name = p.FirstName + ' ' + ISNULL(p.MiddleName,'') + ' ' + p.LastName
    /*** Nowy kod do obsugi logiki ReturnCode ***/
        , @ReturnCode = ISNULL( LEN(ea.EmailAddress,1) )
    FROM HumanResources.Employee_inmem e
    INNER JOIN Person.Person_inmem p ON
        e.BusinessEntityID = p.BusinessEntityID
    INNER JOIN Person.EmailAddress_inmem ea ON
        p.BusinessEntityID = ea.BusinessEntityID
    WHERE e.BusinessEntityID = @BusinessEntityID;

    -- Zwraca 1, jeli nie znajdzie dopasowania, 0 przy dopasowaniu 
    RETURN ( @ReturnCode )
END;
GO
