-- Listing 4-5

CREATE FUNCTION dbo.KodujNYSIIS
(
    @Ciag nvarchar(100)
)
RETURNS nvarchar(6)
WITH RETURNS NULL ON NULL INPUT
AS
BEGIN
DECLARE @Wynik nvarchar(100);
SET @Wynik = UPPER(@Ciag);

-- Krok 1.: Usu wszystkie znaki spoza alfabetu 
WITH Liczby (Lic)
AS
(
  SELECT 1

UNION ALL

SELECT Lic + 1
FROM Liczby
WHERE Lic < LEN(@Wynik)
)
SELECT @Wynik = STUFF 
(
  @Wynik,
  Lic,
  1,
  CASE WHEN SUBSTRING(@Wynik, Lic, 1) >= N'A'
    AND SUBSTRING(@Wynik, Lic, 1) <= N'Z'
    THEN SUBSTRING(@Wynik, Lic, 1)
    ELSE N'.'
  END )
FROM Liczby;

SET @Wynik = REPLACE(@Wynik, N'.', N'');

-- Krok 2.: Zamie pocztkowy n-gram
SELECT TOP (1) @Wynik = STUFF 
(
  @Wynik,
  1,
  LEN(NGram),
  Podstawienie
)
FROM dbo.Podstawienia_NYSIIS
WHERE Lokalizacja = N'Start'
  AND SUBSTRING(@Wynik, 1, LEN(NGram)) = NGram
ORDER BY LEN(NGram) DESC;

-- Krok 3.: Zamie kocowy n-gram
SELECT TOP (1) @Wynik = STUFF 
(
  @Wynik,
  LEN(@Wynik) - LEN(NGram) + 1,
  LEN(NGram),
  Podstawienie
)
FROM dbo.Podstawienia_NYSIIS 
WHERE Lokalizacja = N'Koniec'
  AND SUBSTRING(@Wynik, LEN(@Wynik) - LEN(NGram) + 1, LEN(NGram)) = NGram
ORDER BY LEN(NGram) DESC;

-- Krok 4.: Zachowaj pierwszy znak 
DECLARE @PierwszaLitera nchar(1);
SET @PierwszaLitera = SUBSTRING(@Wynik, 1, 1);

-- Krok 5.: Zamie wszystkie n-gramy ze rodka
DECLARE @Podstawienie nvarchar(10);
DECLARE @i int;
SET @i = 1;
WHILE @i <= LEN(@Wynik)
BEGIN
  SET @Podstawienie = NULL;

-- Wybierz rodkowy n-gram do podstawienia 
SELECT TOP (1) @Podstawienie = Podstawienie
FROM dbo.Podstawienia_NYSIIS
WHERE Lokalizacja = N'Srodek'
AND SUBSTRING(@Wynik, @i, LEN(NGram)) = NGram
ORDER BY LEN(NGram) DESC;

SET @Podstawienie = COALESCE(@Podstawienie, SUBSTRING(@Wynik, @i, 1));

-- Jeli znajdziemy podstawienie, wykonujemy je 
SET @Wynik = STUFF(@Wynik, @i, LEN(@Podstawienie), @Podstawienie)

-- Przejcie do nastpnego n-gramu
SET @i = @i + COALESCE(LEN(@Podstawienie), 1);
END;

-- Zamie pierwszy znak na zapisan wczeniej pierwsz liter 
SET @Wynik = STUFF(@Wynik, 1, 1, @PierwszaLitera);
-- Tutaj zastosujemy reguy dodatkowe dla liter 'H' 
-- Reguy dodatkowe dla liter 'W' zostay zawarte w tabeli podstawie
WITH Liczby (Lic)
AS
(
  SELECT 2 -- Nie sprawdzaj pierwszej litery

  UNION ALL

  SELECT Lic + 1
  FROM Liczby
  WHERE Lic < LEN(@Wynik)
)
SELECT @Wynik = STUFF
  (
  @Wynik,
  Lic,
  1,
  CASE SUBSTRING(@Wynik, Lic, 1)
    WHEN N'H' THEN
      CASE WHEN SUBSTRING(@Wynik, Lic + 1, 1)
        NOT IN (N'A', N'E', N'I', N'O', N'U')
      OR SUBSTRING(@Wynik, Lic - 1, 1)
        NOT IN (N'A', N'E', N'I', N'O', N'U')
      THEN SUBSTRING(@Wynik, Lic - 1, 1)
    ELSE N'H'
  END
 ELSE SUBSTRING(@Wynik, Lic, 1)
END
)
FROM Liczby;

-- Krok 6.: Usu wszystkie ssiadujce duplikaty 
-- Najpierw zamie pierwsz liter kadego dwuliterowego cigu zawierajcego takie same litery na kropk
WITH Liczby (Lic)
AS
(
  SELECT 1

  UNION ALL

  SELECT Lic + 1
  FROM Liczby
  WHERE Lic < LEN(@Wynik)
)
SELECT @Wynik = STUFF
  (
  @Wynik,
  Lic,
  1,
  CASE SUBSTRING(@Wynik, Lic, 1)
    WHEN SUBSTRING(@Wynik, Lic + 1, 1) THEN N'.'
    ELSE SUBSTRING(@Wynik, Lic, 1)
  END
  )
FROM Liczby;

-- Nastpnie zamie wszystkie kropki '.' na pusty cig znakw ''
SET @Wynik = REPLACE(@Wynik, N'.', N'');

-- Krok 7.: Usu z koca znaki 'S' 
WHILE RIGHT(@Wynik, 1) = N'S' AND LEN(@Wynik) > 1
  SET @Wynik = STUFF(@Wynik, LEN(@Wynik), 1, N'');

-- Krok 8.: Usu z koca znaki 'A' 
WHILE RIGHT(@Wynik, 1) = N'A' AND LEN(@Wynik) > 1
  SET @Wynik = STUFF(@Wynik, LEN(@Wynik), 1, N'');

-- Krok 9.: Zamie kocowe znaki 'AY' na 'Y'
IF RIGHT(@Wynik, 2) = 'AY'
  SET @Wynik = STUFF(@Wynik, LEN(@Wynik) - 1, 1, N'');

-- Krok 10.: Skr wynik do szeciu znakw
RETURN COALESCE(SUBSTRING(@Wynik, 1, 6), '');
END;
GO

