-- Listing 7-9

CREATE TRIGGER Production.ProductEnforceStandardSizes
ON Production.Product
AFTER INSERT, UPDATE
NOT FOR REPLICATION
AS
BEGIN
  -- Upewnij si, czy zosta zmodyfikowany przynajmniej jeden wiersz
  -- i czy zmienione zostay kolumny Size lub SizeUnitMeasureCode.
  IF (@@ROWCOUNT > 0) AND (UPDATE(SizeUnitMeasureCode) OR UPDATE(Size))
  BEGIN
    -- Usu komunikaty "rows affected". 
    SET NOCOUNT ON;
    -- Przyjmuj tylko znane jednostki miary lub NULL.
    IF EXISTS
    (
      SELECT 1
      FROM inserted
      WHERE NOT
      ( SizeUnitMeasureCode IN (N'M', N'DM', N'CM', N'MM', N'IN')
        OR SizeUnitMeasureCode IS NULL
      )
    )
    BEGIN
      -- Jeli nie rozpoznasz jednostki miary, zwr bd i wycofaj transakcj. 
      RAISERROR ('Nieznana jednostka miary.', 10, 127);
      ROLLBACK TRANSACTION;
    END
    ELSE
    BEGIN
      -- Po rozpoznaniu jednostki miary wstaw do SizeUnitMeasureCodeIf oznaczenie centymetrw i przelicz warto Size. 
      UPDATE Production.Product
      SET SizeUnitMeasureCode = CASE
          WHEN Production.Product.SizeUnitMeasureCode IS NULL THEN NULL ELSE N'CM' END,
        Size = CAST (
          CAST ( CAST(i.Size AS float) *
            CASE i.SizeUnitMeasureCode
              WHEN N'M' THEN 100.0
              WHEN N'DM' THEN 10.0
              WHEN N'CM' THEN 1.0
              WHEN N'MM' THEN 0.10
              WHEN N'IN' THEN 2.54
            END
          AS int
          ) AS nvarchar(5)
        )
      FROM inserted i
      WHERE Production.Product.ProductID = i.ProductID
      AND i.SizeUnitMeasureCode IS NOT NULL;
    END;
  END;
END;
GO

