-- Listing 6.12

CREATE PROCEDURE selAddressModifiedDate
  ( @BeginModifiedDate DATETIME
  , @EndmodifiedDate DATETIME )
WITH
  NATIVE_COMPILATION  -- wiersz 5.
  , SCHEMABINDING     -- wiersz 6.
  , EXECUTE AS OWNER  -- wiersz 7. 
AS
BEGIN ATOMIC
  WITH
  ( TRANSACTION ISOLATION LEVEL = SNAPSHOT  -- wiersz 11.
    LANGUAGE = N'us_english')

 -- Kod T-SQL 
  SELECT AddressID, AddressLine1
  , AddressLine2, City
  , StateProvinceID, PostalCode
  , rowguid, ModifiedDate
  FROM [MOD].[Address]
  WHERE ModifiedDate
  BETWEEN @BeginModifiedDate AND @EndmodifiedDate;
END;

