-- Listing 3.12

-- Deklaracje zmiennych
DECLARE @sql nvarchar(4000);

DECLARE @temp_pivot table
 (
  TerritoryID int NOT NULL PRIMARY KEY,
  CountryRegion nvarchar(20) NOT NULL,
  CountryRegionCode nvarchar(3) NOT NULL
 );

-- Pobierz nazwy kolumn z wierszy tabel rdowych
INSERT INTO @temp_pivot
 (
  TerritoryID,
  CountryRegion,
  CountryRegionCode
 )
SELECT
 TerritoryID,
 Name,
 CountryRegionCode
 FROM Sales.SalesTerritory
 GROUP BY
    TerritoryID,
    Name,
    CountryRegionCode;

-- Generowanie dynamicznego zapytania SQL 
SET @sql = N'SELECT' +
    SUBSTRING(
      (
        SELECT N', SUM(CASE WHEN t.TerritoryID = ' +
          CAST(TerritoryID AS NVARCHAR(3)) +
            N' THEN 1 ELSE 0 END) AS ' + QUOTENAME(CountryRegion) AS "*"
        FROM @temp_pivot
        FOR XML PATH('')
    ), 2, 4000) +
    N' FROM Sales.SalesOrderHeader soh ' +
    N' INNER JOIN Sales.SalesTerritory t ' +
    N' ON soh.TerritoryID = t.TerritoryID; ' ;

-- Wywietl i wykonaj dynamiczny SQL
PRINT @sql;

EXEC (@sql);

